/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.dt.api.jpa.roles;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.overlord.apiman.dt.api.beans.idm.PermissionBean;
import org.overlord.apiman.dt.api.beans.idm.RoleBean;
import org.overlord.apiman.dt.api.beans.idm.RoleMembershipBean;
import org.overlord.apiman.dt.api.beans.idm.UserBean;
import org.overlord.apiman.dt.api.beans.search.SearchCriteriaBean;
import org.overlord.apiman.dt.api.beans.search.SearchResultsBean;
import org.overlord.apiman.dt.api.core.IIdmStorage;
import org.overlord.apiman.dt.api.core.exceptions.AlreadyExistsException;
import org.overlord.apiman.dt.api.core.exceptions.DoesNotExistException;
import org.overlord.apiman.dt.api.core.exceptions.StorageException;
import org.overlord.apiman.dt.api.jpa.AbstractJpaStorage;
import org.overlord.apiman.dt.api.jpa.JpaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JpaIdmStorage
extends AbstractJpaStorage
implements IIdmStorage {
    private static Logger logger = LoggerFactory.getLogger(JpaIdmStorage.class);

    public void createUser(UserBean user) throws StorageException, AlreadyExistsException {
        user.setJoinedOn(new Date());
        super.create((Object)user);
    }

    public UserBean getUser(String userId) throws StorageException, DoesNotExistException {
        return (UserBean)super.get(userId, UserBean.class);
    }

    public void updateUser(UserBean user) throws StorageException, DoesNotExistException {
        super.update((Object)user);
    }

    public SearchResultsBean<UserBean> findUsers(SearchCriteriaBean criteria) throws StorageException {
        return super.find(criteria, UserBean.class);
    }

    public void createRole(RoleBean role) throws StorageException, AlreadyExistsException {
        super.create((Object)role);
    }

    public void updateRole(RoleBean role) throws StorageException, DoesNotExistException {
        super.update((Object)role);
    }

    public void deleteRole(RoleBean role) throws StorageException, DoesNotExistException {
        EntityManager entityManager = this.emf.createEntityManager();
        try {
            entityManager.getTransaction().begin();
            Query query = entityManager.createQuery("DELETE from RoleMembershipBean m WHERE m.roleId = :roleId");
            query.setParameter("roleId", (Object)role.getId());
            query.executeUpdate();
            entityManager.getTransaction().commit();
        }
        catch (Throwable t) {
            JpaUtil.rollbackQuietly((EntityManager)entityManager);
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            entityManager.close();
        }
        super.delete((Object)role);
    }

    public RoleBean getRole(String roleId) throws StorageException, DoesNotExistException {
        return (RoleBean)super.get(roleId, RoleBean.class);
    }

    public SearchResultsBean<RoleBean> findRoles(SearchCriteriaBean criteria) throws StorageException {
        return super.find(criteria, RoleBean.class);
    }

    public void createMembership(RoleMembershipBean membership) throws StorageException, AlreadyExistsException {
        super.create((Object)membership);
    }

    public void deleteMembership(String userId, String roleId, String organizationId) throws StorageException, DoesNotExistException {
        EntityManager entityManager = this.emf.createEntityManager();
        try {
            entityManager.getTransaction().begin();
            Query query = entityManager.createQuery("DELETE FROM RoleMembershipBean m WHERE m.roleId = :roleId AND m.userId = :userId AND m.organizationId = :orgId");
            query.setParameter("roleId", (Object)roleId);
            query.setParameter("userId", (Object)userId);
            query.setParameter("orgId", (Object)organizationId);
            if (query.executeUpdate() == 0) {
                throw new DoesNotExistException();
            }
            entityManager.getTransaction().commit();
        }
        catch (DoesNotExistException dne) {
            JpaUtil.rollbackQuietly((EntityManager)entityManager);
            throw dne;
        }
        catch (Throwable t) {
            JpaUtil.rollbackQuietly((EntityManager)entityManager);
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            entityManager.close();
        }
    }

    public void deleteMemberships(String userId, String organizationId) throws StorageException {
        EntityManager entityManager = this.emf.createEntityManager();
        try {
            entityManager.getTransaction().begin();
            Query query = entityManager.createQuery("DELETE FROM RoleMembershipBean m WHERE m.userId = :userId AND m.organizationId = :orgId");
            query.setParameter("userId", (Object)userId);
            query.setParameter("orgId", (Object)organizationId);
            query.executeUpdate();
            entityManager.getTransaction().commit();
        }
        catch (Throwable t) {
            JpaUtil.rollbackQuietly((EntityManager)entityManager);
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            entityManager.close();
        }
    }

    public Set<RoleMembershipBean> getUserMemberships(String userId) throws StorageException {
        HashSet<RoleMembershipBean> memberships = new HashSet<RoleMembershipBean>();
        EntityManager entityManager = this.emf.createEntityManager();
        try {
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(RoleMembershipBean.class);
            Root from = criteriaQuery.from(RoleMembershipBean.class);
            criteriaQuery.where((Expression)builder.equal((Expression)from.get("userId"), (Object)userId));
            TypedQuery typedQuery = entityManager.createQuery(criteriaQuery);
            List resultList = typedQuery.getResultList();
            memberships.addAll(resultList);
            HashSet<RoleMembershipBean> hashSet = memberships;
            return hashSet;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            entityManager.close();
        }
    }

    public Set<RoleMembershipBean> getUserMemberships(String userId, String organizationId) throws StorageException {
        HashSet<RoleMembershipBean> memberships = new HashSet<RoleMembershipBean>();
        EntityManager entityManager = this.emf.createEntityManager();
        try {
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(RoleMembershipBean.class);
            Root from = criteriaQuery.from(RoleMembershipBean.class);
            criteriaQuery.where(new Predicate[]{builder.equal((Expression)from.get("userId"), (Object)userId), builder.equal((Expression)from.get("organizationId"), (Object)organizationId)});
            TypedQuery typedQuery = entityManager.createQuery(criteriaQuery);
            List resultList = typedQuery.getResultList();
            memberships.addAll(resultList);
            HashSet<RoleMembershipBean> hashSet = memberships;
            return hashSet;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            entityManager.close();
        }
    }

    public Set<RoleMembershipBean> getOrgMemberships(String organizationId) throws StorageException {
        HashSet<RoleMembershipBean> memberships = new HashSet<RoleMembershipBean>();
        EntityManager entityManager = this.emf.createEntityManager();
        try {
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(RoleMembershipBean.class);
            Root from = criteriaQuery.from(RoleMembershipBean.class);
            criteriaQuery.where((Expression)builder.equal((Expression)from.get("organizationId"), (Object)organizationId));
            TypedQuery typedQuery = entityManager.createQuery(criteriaQuery);
            List resultList = typedQuery.getResultList();
            memberships.addAll(resultList);
            HashSet<RoleMembershipBean> hashSet = memberships;
            return hashSet;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            entityManager.close();
        }
    }

    public Set<PermissionBean> getPermissions(String userId) throws StorageException {
        HashSet<PermissionBean> permissions = new HashSet<PermissionBean>();
        EntityManager entityManager = this.emf.createEntityManager();
        try {
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(RoleMembershipBean.class);
            Root from = criteriaQuery.from(RoleMembershipBean.class);
            criteriaQuery.where((Expression)builder.equal((Expression)from.get("userId"), (Object)userId));
            TypedQuery typedQuery = entityManager.createQuery(criteriaQuery);
            List resultList = typedQuery.getResultList();
            for (RoleMembershipBean membership : resultList) {
                RoleBean role = this.getRole(membership.getRoleId());
                String qualifier = membership.getOrganizationId();
                for (String permission : role.getPermissions()) {
                    PermissionBean p = new PermissionBean();
                    p.setName(permission);
                    p.setOrganizationId(qualifier);
                    permissions.add(p);
                }
            }
            HashSet<PermissionBean> hashSet = permissions;
            return hashSet;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            entityManager.close();
        }
    }
}

