/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.dt.api.jpa.roles;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.overlord.apiman.dt.api.beans.idm.PermissionBean;
import org.overlord.apiman.dt.api.beans.idm.PermissionType;
import org.overlord.apiman.dt.api.beans.idm.RoleBean;
import org.overlord.apiman.dt.api.beans.idm.RoleMembershipBean;
import org.overlord.apiman.dt.api.beans.idm.UserBean;
import org.overlord.apiman.dt.api.beans.search.SearchCriteriaBean;
import org.overlord.apiman.dt.api.beans.search.SearchResultsBean;
import org.overlord.apiman.dt.api.core.IIdmStorage;
import org.overlord.apiman.dt.api.core.exceptions.AlreadyExistsException;
import org.overlord.apiman.dt.api.core.exceptions.DoesNotExistException;
import org.overlord.apiman.dt.api.core.exceptions.StorageException;
import org.overlord.apiman.dt.api.jpa.AbstractJpaStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JpaIdmStorage
extends AbstractJpaStorage
implements IIdmStorage {
    private static Logger logger = LoggerFactory.getLogger(JpaIdmStorage.class);

    public void createUser(UserBean user) throws StorageException, AlreadyExistsException {
        user.setJoinedOn(new Date());
        this.beginTx();
        try {
            super.create((Object)user);
            this.commitTx();
        }
        catch (AlreadyExistsException e) {
            this.rollbackTx();
            throw e;
        }
        catch (StorageException e) {
            this.rollbackTx();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserBean getUser(String userId) throws StorageException, DoesNotExistException {
        this.beginTx();
        try {
            UserBean userBean = (UserBean)super.get(userId, UserBean.class);
            return userBean;
        }
        finally {
            this.commitTx();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUser(UserBean user) throws StorageException, DoesNotExistException {
        this.beginTx();
        try {
            super.update((Object)user);
        }
        finally {
            this.commitTx();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResultsBean<UserBean> findUsers(SearchCriteriaBean criteria) throws StorageException {
        this.beginTx();
        try {
            SearchResultsBean searchResultsBean = super.find(criteria, UserBean.class);
            return searchResultsBean;
        }
        finally {
            this.commitTx();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRole(RoleBean role) throws StorageException, AlreadyExistsException {
        this.beginTx();
        try {
            super.create((Object)role);
        }
        finally {
            this.commitTx();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRole(RoleBean role) throws StorageException, DoesNotExistException {
        this.beginTx();
        try {
            super.update((Object)role);
        }
        finally {
            this.commitTx();
        }
    }

    public void deleteRole(RoleBean role) throws StorageException, DoesNotExistException {
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            RoleBean prole = (RoleBean)this.get(role.getId(), RoleBean.class);
            Query query = entityManager.createQuery("DELETE from RoleMembershipBean m WHERE m.roleId = :roleId");
            query.setParameter("roleId", (Object)role.getId());
            query.executeUpdate();
            super.delete((Object)prole);
            this.commitTx();
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            this.rollbackTx();
            throw new StorageException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoleBean getRole(String roleId) throws StorageException, DoesNotExistException {
        this.beginTx();
        try {
            RoleBean roleBean = this.getRoleInternal(roleId);
            return roleBean;
        }
        finally {
            this.commitTx();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResultsBean<RoleBean> findRoles(SearchCriteriaBean criteria) throws StorageException {
        this.beginTx();
        try {
            SearchResultsBean searchResultsBean = super.find(criteria, RoleBean.class);
            return searchResultsBean;
        }
        finally {
            this.commitTx();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMembership(RoleMembershipBean membership) throws StorageException, AlreadyExistsException {
        this.beginTx();
        try {
            super.create((Object)membership);
        }
        finally {
            this.commitTx();
        }
    }

    public void deleteMembership(String userId, String roleId, String organizationId) throws StorageException, DoesNotExistException {
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            Query query = entityManager.createQuery("DELETE FROM RoleMembershipBean m WHERE m.roleId = :roleId AND m.userId = :userId AND m.organizationId = :orgId");
            query.setParameter("roleId", (Object)roleId);
            query.setParameter("userId", (Object)userId);
            query.setParameter("orgId", (Object)organizationId);
            if (query.executeUpdate() == 0) {
                throw new DoesNotExistException();
            }
            this.commitTx();
        }
        catch (DoesNotExistException dne) {
            this.rollbackTx();
            throw dne;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            this.rollbackTx();
            throw new StorageException(t);
        }
    }

    public void deleteMemberships(String userId, String organizationId) throws StorageException {
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            Query query = entityManager.createQuery("DELETE FROM RoleMembershipBean m WHERE m.userId = :userId AND m.organizationId = :orgId");
            query.setParameter("userId", (Object)userId);
            query.setParameter("orgId", (Object)organizationId);
            query.executeUpdate();
            this.commitTx();
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            this.rollbackTx();
            throw new StorageException(t);
        }
    }

    public Set<RoleMembershipBean> getUserMemberships(String userId) throws StorageException {
        HashSet<RoleMembershipBean> memberships = new HashSet<RoleMembershipBean>();
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(RoleMembershipBean.class);
            Root from = criteriaQuery.from(RoleMembershipBean.class);
            criteriaQuery.where((Expression)builder.equal((Expression)from.get("userId"), (Object)userId));
            TypedQuery typedQuery = entityManager.createQuery(criteriaQuery);
            List resultList = typedQuery.getResultList();
            memberships.addAll(resultList);
            this.commitTx();
            return memberships;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            this.rollbackTx();
            throw new StorageException(t);
        }
    }

    public Set<RoleMembershipBean> getUserMemberships(String userId, String organizationId) throws StorageException {
        HashSet<RoleMembershipBean> memberships = new HashSet<RoleMembershipBean>();
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(RoleMembershipBean.class);
            Root from = criteriaQuery.from(RoleMembershipBean.class);
            criteriaQuery.where(new Predicate[]{builder.equal((Expression)from.get("userId"), (Object)userId), builder.equal((Expression)from.get("organizationId"), (Object)organizationId)});
            TypedQuery typedQuery = entityManager.createQuery(criteriaQuery);
            List resultList = typedQuery.getResultList();
            memberships.addAll(resultList);
            this.commitTx();
            return memberships;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            this.rollbackTx();
            throw new StorageException(t);
        }
    }

    public Set<RoleMembershipBean> getOrgMemberships(String organizationId) throws StorageException {
        HashSet<RoleMembershipBean> memberships = new HashSet<RoleMembershipBean>();
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(RoleMembershipBean.class);
            Root from = criteriaQuery.from(RoleMembershipBean.class);
            criteriaQuery.where((Expression)builder.equal((Expression)from.get("organizationId"), (Object)organizationId));
            TypedQuery typedQuery = entityManager.createQuery(criteriaQuery);
            List resultList = typedQuery.getResultList();
            memberships.addAll(resultList);
            this.commitTx();
            return memberships;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            this.rollbackTx();
            throw new StorageException(t);
        }
    }

    public Set<PermissionBean> getPermissions(String userId) throws StorageException {
        HashSet<PermissionBean> permissions = new HashSet<PermissionBean>();
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(RoleMembershipBean.class);
            Root from = criteriaQuery.from(RoleMembershipBean.class);
            criteriaQuery.where((Expression)builder.equal((Expression)from.get("userId"), (Object)userId));
            TypedQuery typedQuery = entityManager.createQuery(criteriaQuery);
            List resultList = typedQuery.getResultList();
            for (RoleMembershipBean membership : resultList) {
                RoleBean role = this.getRoleInternal(membership.getRoleId());
                String qualifier = membership.getOrganizationId();
                for (PermissionType permission : role.getPermissions()) {
                    PermissionBean p = new PermissionBean();
                    p.setName(permission);
                    p.setOrganizationId(qualifier);
                    permissions.add(p);
                }
            }
            this.commitTx();
            return permissions;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            this.rollbackTx();
            throw new StorageException(t);
        }
    }

    protected RoleBean getRoleInternal(String roleId) throws StorageException, DoesNotExistException {
        return (RoleBean)super.get(roleId, RoleBean.class);
    }
}

