/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.dt.api.fuse6.auth;

import javax.security.auth.login.Configuration;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.cxf.interceptor.security.AuthenticationException;
import org.apache.cxf.interceptor.security.JAASLoginInterceptor;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;
import org.overlord.apiman.common.auth.AuthPrincipal;
import org.overlord.apiman.common.auth.AuthToken;
import org.overlord.apiman.common.auth.AuthTokenUtil;
import org.overlord.apiman.dt.api.fuse6.auth.AuthTokenRequestHandler;
import org.overlord.apiman.dt.api.fuse6.security.FuseSecurityContext;

public class AuthTokenRequestHandler
implements RequestHandler {
    private String realm = "apiman";
    private boolean signatureRequired;
    private String keystorePath;
    private String keystorePassword;
    private String keyAlias;
    private String keyPassword;
    private final JAASLoginInterceptor interceptor = new /* Unavailable Anonymous Inner Class!! */;

    public AuthTokenRequestHandler() {
        this.setContextName("karaf");
        this.setRoleClassifier("RolePrincipal");
        this.setRoleClassifierType("classname");
        this.setRealm("apiman-dt-api");
    }

    public Response handleRequest(Message message, ClassResourceInfo cri) {
        String authHeader = new HttpHeadersImpl(message).getHeaderString("Authorization");
        if (authHeader == null) {
            return this.createAuthResponse(message);
        }
        if (authHeader.toUpperCase().startsWith("BASIC")) {
            try {
                this.interceptor.handleMessage(message);
                SecurityContext securityCtx = (SecurityContext)message.get(SecurityContext.class);
                FuseSecurityContext.set((SecurityContext)securityCtx, (HttpHeaders)new HttpHeadersImpl(message));
                return null;
            }
            catch (AuthenticationException ex) {
                return this.createAuthResponse(message);
            }
            catch (SecurityException ex) {
                return this.createAuthResponse(message);
            }
        }
        if (authHeader.toUpperCase().startsWith("AUTH-TOKEN")) {
            AuthToken token = this.parseAuthorizationToken(authHeader);
            if (token == null) {
                return this.createAuthResponse(message);
            }
            this.doTokenAuth(token, message);
            return null;
        }
        return this.createAuthResponse(message);
    }

    private AuthToken parseAuthorizationToken(String authHeader) {
        try {
            String tokenEncoded = authHeader.substring(11);
            return AuthTokenUtil.consumeToken((String)tokenEncoded);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    protected void doTokenAuth(AuthToken token, Message message) {
        AuthPrincipal principal = new AuthPrincipal(token.getPrincipal());
        principal.addRoles(token.getRoles());
        2 securityCtx = new /* Unavailable Anonymous Inner Class!! */;
        FuseSecurityContext.set((SecurityContext)securityCtx, (HttpHeaders)new HttpHeadersImpl(message));
    }

    protected Response createAuthResponse(Message message) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
        builder.header("WWW-Authenticate", (Object)String.format("BASIC realm=\"%1$s\"", this.getRealm()));
        return builder.build();
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setContextName(String name) {
        this.interceptor.setContextName(name);
    }

    public void setLoginConfig(Configuration config) {
        this.interceptor.setLoginConfig(config);
    }

    public void setRoleClassifier(String value) {
        this.interceptor.setRoleClassifier(value);
    }

    public String getRoleClassifier() {
        return this.interceptor.getRoleClassifier();
    }

    public void setRoleClassifierType(String value) {
        this.interceptor.setRoleClassifierType(value);
    }

    public String getRoleClassifierType() {
        return this.interceptor.getRoleClassifierType();
    }
}

