/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.dt.api.fuse6.security;

import javax.ws.rs.core.HttpHeaders;
import org.apache.cxf.security.SecurityContext;
import org.overlord.apiman.dt.api.security.impl.AbstractSecurityContext;

public class FuseSecurityContext
extends AbstractSecurityContext {
    private static final ThreadLocal<SecurityContext> cxfSecurityContext = new ThreadLocal();
    private static final ThreadLocal<HttpHeaders> headers = new ThreadLocal();

    public String getRequestHeader(String headerName) {
        return headers.get().getHeaderString(headerName);
    }

    public String getCurrentUser() {
        return cxfSecurityContext.get().getUserPrincipal().getName();
    }

    public boolean isAdmin() {
        return cxfSecurityContext.get().isUserInRole("apiadmin");
    }

    public static void set(SecurityContext ctx, HttpHeaders reqHeaders) {
        cxfSecurityContext.set(ctx);
        headers.set(reqHeaders);
    }

    public static void clear() {
        AbstractSecurityContext.clearPermissions();
        cxfSecurityContext.remove();
        headers.remove();
    }
}

