/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.dt.ui.server.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class UrlFetchProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = -4704803997251798191L;
    private static Set<String> EXCLUDE_HEADERS = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block7: {
            String url = req.getHeader("X-Apiman-Url");
            if (url == null) {
                resp.sendError(500, "No URL specified in X-Apiman-Url");
                return;
            }
            URL remoteUrl = new URL(url);
            HttpURLConnection remoteConn = (HttpURLConnection)remoteUrl.openConnection();
            InputStream remoteIS = null;
            ServletOutputStream responseOS = null;
            try {
                remoteConn.connect();
                Map<String, List<String>> headerFields = remoteConn.getHeaderFields();
                for (String headerName : headerFields.keySet()) {
                    if (headerName == null || EXCLUDE_HEADERS.contains(headerName)) continue;
                    String headerValue = remoteConn.getHeaderField(headerName);
                    resp.setHeader(headerName, headerValue);
                }
                resp.setHeader("Cache-control", "no-cache, no-store, must-revalidate");
                remoteIS = remoteConn.getInputStream();
                responseOS = resp.getOutputStream();
                IOUtils.copy((InputStream)remoteIS, (OutputStream)responseOS);
                resp.flushBuffer();
                IOUtils.closeQuietly((OutputStream)responseOS);
            }
            catch (Exception e) {
                resp.sendError(500, e.getMessage());
                break block7;
            }
            finally {
                IOUtils.closeQuietly(responseOS);
                IOUtils.closeQuietly(remoteIS);
            }
            IOUtils.closeQuietly((InputStream)remoteIS);
        }
    }

    static {
        EXCLUDE_HEADERS.add("ETag");
        EXCLUDE_HEADERS.add("Last-Modified");
        EXCLUDE_HEADERS.add("Date");
        EXCLUDE_HEADERS.add("Cache-control");
    }
}

