/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.rt.gateway.servlet.connectors;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.overlord.apiman.rt.engine.IConnectorFactory;
import org.overlord.apiman.rt.engine.IServiceConnector;
import org.overlord.apiman.rt.engine.async.AsyncResultImpl;
import org.overlord.apiman.rt.engine.async.IAsyncHandler;
import org.overlord.apiman.rt.engine.async.IAsyncResult;
import org.overlord.apiman.rt.engine.beans.Service;
import org.overlord.apiman.rt.engine.beans.ServiceRequest;
import org.overlord.apiman.rt.engine.beans.ServiceResponse;
import org.overlord.apiman.rt.engine.beans.exceptions.ConnectorException;
import org.overlord.apiman.rt.gateway.servlet.GatewayThreadContext;
import org.overlord.apiman.rt.gateway.servlet.i18n.Messages;

public class HttpConnectorFactory
implements IConnectorFactory {
    private static final Set<String> SUPPRESSED_HEADERS = new HashSet<String>();
    private CloseableHttpClient httpclient = HttpClientBuilder.create().build();

    public IServiceConnector createConnector(ServiceRequest request, final Service service) {
        return new IServiceConnector(){

            public void invoke(ServiceRequest request, IAsyncHandler<ServiceResponse> handler) throws ConnectorException {
                try {
                    ServiceResponse response = HttpConnectorFactory.this.doInvoke(request, service);
                    handler.handle((IAsyncResult)AsyncResultImpl.create((Object)response));
                }
                catch (Exception e) {
                    handler.handle((IAsyncResult)AsyncResultImpl.create((Throwable)e));
                }
            }
        };
    }

    protected ServiceResponse doInvoke(ServiceRequest request, Service service) throws ConnectorException {
        InputStreamEntity entity;
        String endpoint = service.getEndpoint();
        if (endpoint.endsWith("/")) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        endpoint = endpoint + request.getDestination();
        HttpGet httpmethod = null;
        if ("GET".equals(request.getType())) {
            httpmethod = new HttpGet(endpoint);
        } else if ("PUT".equals(request.getType())) {
            httpmethod = new HttpPut(endpoint);
            entity = new InputStreamEntity(request.getBody(), this.getContentLength(request));
            ((HttpPut)httpmethod).setEntity((HttpEntity)entity);
        } else if ("POST".equals(request.getType())) {
            httpmethod = new HttpPost(endpoint);
            entity = new InputStreamEntity(request.getBody(), this.getContentLength(request));
            ((HttpPost)httpmethod).setEntity((HttpEntity)entity);
        } else if ("DELETE".equals(request.getType())) {
            httpmethod = new HttpDelete(endpoint);
        } else {
            throw new ConnectorException(Messages.i18n.format("HttpConnectorFactory.MethodNotSupported", new Object[]{request.getType()}));
        }
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            String hname = (String)entry.getKey();
            String hval = (String)entry.getValue();
            if (SUPPRESSED_HEADERS.contains(hname)) continue;
            httpmethod.setHeader(hname, hval);
        }
        ServiceResponse sresponse = null;
        try {
            Header[] headers;
            CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpmethod);
            StatusLine statusLine = response.getStatusLine();
            sresponse = GatewayThreadContext.getServiceResponse();
            for (Header header : headers = response.getAllHeaders()) {
                sresponse.getHeaders().put(header.getName(), header.getValue());
            }
            sresponse.setCode(statusLine.getStatusCode());
            sresponse.setMessage(statusLine.getReasonPhrase());
            sresponse.setBody(response.getEntity().getContent());
            return sresponse;
        }
        catch (Exception e) {
            throw new ConnectorException(Messages.i18n.format("HttpConnectorFactory.ErrorInvokingService", new Object[0]), (Throwable)e);
        }
    }

    private long getContentLength(ServiceRequest request) {
        String cl = (String)request.getHeaders().get("Content-Length");
        if (cl == null || cl.trim().length() == 0) {
            return -1L;
        }
        return new Integer(cl).intValue();
    }

    static {
        SUPPRESSED_HEADERS.add("Transfer-Encoding");
        SUPPRESSED_HEADERS.add("Content-Length");
        SUPPRESSED_HEADERS.add("X-API-Key");
    }
}

