/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.rt.test.server;

import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.overlord.apiman.rt.api.rest.impl.ApplicationResourceImpl;
import org.overlord.apiman.rt.api.rest.impl.RtApiApplication;
import org.overlord.apiman.rt.api.rest.impl.ServiceResourceImpl;
import org.overlord.apiman.rt.api.rest.impl.SystemResourceImpl;
import org.overlord.apiman.rt.api.rest.impl.mappers.RestExceptionMapper;
import org.overlord.apiman.rt.war.listeners.WarGatewayBootstrapper;
import org.overlord.apiman.rt.war.servlets.WarGatewayServlet;

public class GatewayServer {
    private Server server;
    private int port;

    public GatewayServer(int port) {
        this.port = port;
    }

    public void start() throws Exception {
        long startTime = System.currentTimeMillis();
        System.out.println("**** Starting Server (" + this.getClass().getSimpleName() + ")");
        this.preStart();
        ContextHandlerCollection handlers = new ContextHandlerCollection();
        this.addModulesToJetty(handlers);
        this.server = new Server(this.port);
        this.server.setHandler((Handler)handlers);
        this.server.start();
        long endTime = System.currentTimeMillis();
        System.out.println("******* Started in " + (endTime - startTime) + "ms");
    }

    private void preStart() {
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addModulesToJetty(ContextHandlerCollection handlers) throws Exception {
        ServletContextHandler server = new ServletContextHandler(1);
        server.setContextPath("/");
        server.addEventListener((EventListener)new WarGatewayBootstrapper());
        ServletHolder servlet = new ServletHolder((Servlet)new WarGatewayServlet());
        server.addServlet(servlet, "/gateway/*");
        servlet = new ServletHolder((Servlet)new HttpServletDispatcher());
        servlet.setInitParameter("javax.ws.rs.Application", TestGatewayApplication.class.getName());
        servlet.setInitOrder(1);
        server.addServlet(servlet, "/api/*");
        handlers.addHandler((Handler)server);
    }

    public static class TestGatewayApplication
    extends RtApiApplication {
        public Set<Class<?>> getClasses() {
            HashSet classes = new HashSet();
            classes.add(SystemResourceImpl.class);
            classes.add(ServiceResourceImpl.class);
            classes.add(ApplicationResourceImpl.class);
            classes.add(RestExceptionMapper.class);
            return classes;
        }
    }
}

