/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.tools.devsvr.gateway;

import org.overlord.apiman.rt.engine.components.IPolicyFailureFactoryComponent;
import org.overlord.apiman.rt.engine.components.ISharedStateComponent;
import org.overlord.apiman.rt.engine.impl.InMemoryRegistry;
import org.overlord.apiman.rt.engine.impl.InMemorySharedStateComponent;
import org.overlord.apiman.rt.engine.policy.PolicyFactoryImpl;
import org.overlord.apiman.rt.test.server.EchoServer;
import org.overlord.apiman.rt.test.server.GatewayServer;
import org.overlord.apiman.rt.war.WarPolicyFailureFactoryComponent;
import org.overlord.apiman.rt.war.connectors.HttpConnectorFactory;

public class GatewayDevServer {
    private static final int GATEWAY_PORT = 6666;
    private static final int ECHO_PORT = 9001;
    private static final String APIMAN_RT_GATEWAY_SERVER_PORT = "apiman.gateway.server.port";
    private static final String ECHO_PORT_PROPERTY = "apiman.echo.server.port";

    public static void main(String[] args) throws Exception {
        int gatewayPort = GatewayDevServer.getGatewayPort();
        int echoPort = GatewayDevServer.getEchoPort();
        System.setProperty("apiman-rt.registry", InMemoryRegistry.class.getName());
        System.setProperty("apiman-rt.connector-factory", HttpConnectorFactory.class.getName());
        System.setProperty("apiman-rt.policy-factory", PolicyFactoryImpl.class.getName());
        System.setProperty("apiman-rt.gateway.server.port", String.valueOf(gatewayPort));
        System.setProperty("apiman-rt.components." + ISharedStateComponent.class.getSimpleName(), InMemorySharedStateComponent.class.getName());
        System.setProperty("apiman-rt.components." + IPolicyFailureFactoryComponent.class.getSimpleName(), WarPolicyFailureFactoryComponent.class.getName());
        GatewayServer server = new GatewayServer(gatewayPort);
        server.start();
        EchoServer echo = new EchoServer(echoPort);
        echo.start();
        while (true) {
            Thread.sleep(5000L);
        }
    }

    private static int getGatewayPort() {
        int port = 6666;
        if (System.getProperty(APIMAN_RT_GATEWAY_SERVER_PORT) != null) {
            port = new Integer(System.getProperty(APIMAN_RT_GATEWAY_SERVER_PORT));
        }
        return port;
    }

    private static int getEchoPort() {
        int port = 9001;
        if (System.getProperty(ECHO_PORT_PROPERTY) != null) {
            port = new Integer(System.getProperty(ECHO_PORT_PROPERTY));
        }
        return port;
    }
}

