/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.activity.server.rest.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.overlord.bam.activity.model.ActivityUnit;
import org.overlord.bam.activity.server.ActivityServer;
import org.overlord.bam.activity.server.QuerySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTActivityServer
implements ActivityServer {
    private static final Logger LOG = Logger.getLogger(RESTActivityServer.class.getName());
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String STORE = "/overlord-bam/activity/store";
    private static final String QUERY = "/overlord-bam/activity/query";
    private String _url = "http://localhost:8080";

    public void setServerURL(String url) {
        this._url = url;
    }

    public String getServerURL() {
        return this._url;
    }

    public void store(List<ActivityUnit> activities) throws Exception {
        URL storeUrl = new URL(this._url + STORE);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer store: " + activities);
        }
        HttpURLConnection connection = (HttpURLConnection)storeUrl.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Content-Type", "application/json");
        OutputStream os = connection.getOutputStream();
        MAPPER.writeValue(os, activities);
        os.flush();
        os.close();
        InputStream is = connection.getInputStream();
        byte[] b = new byte[is.available()];
        is.read(b);
        is.close();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer result: " + new String(b));
        }
    }

    public List<ActivityUnit> query(QuerySpec query) throws Exception {
        List ret = null;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer query: " + query);
        }
        URL queryUrl = new URL(this._url + QUERY);
        HttpURLConnection connection = (HttpURLConnection)queryUrl.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Content-Type", "application/json");
        OutputStream os = connection.getOutputStream();
        MAPPER.writeValue(os, (Object)query);
        os.flush();
        os.close();
        InputStream is = connection.getInputStream();
        ret = (List)MAPPER.readValue(is, (TypeReference)new TypeReference<List<ActivityUnit>>(){});
        is.close();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer result: " + ret);
        }
        return ret;
    }
}

