/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.activity.server.rest.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.bam.activity.model.ActivityType;
import org.overlord.bam.activity.model.ActivityUnit;
import org.overlord.bam.activity.server.ActivityServer;
import org.overlord.bam.activity.server.QuerySpec;
import org.overlord.bam.activity.util.ActivityUtil;

public class RESTActivityServer
implements ActivityServer {
    private static final Logger LOG = Logger.getLogger(RESTActivityServer.class.getName());
    private static final String STORE = "/overlord-bam/activity/store";
    private static final String UNIT = "/overlord-bam/activity/unit";
    private static final String QUERY = "/overlord-bam/activity/query";
    private String _url = "http://localhost:8080";

    public void setServerURL(String url) {
        this._url = url;
    }

    public String getServerURL() {
        return this._url;
    }

    public void store(List<ActivityUnit> activities) throws Exception {
        URL storeUrl = new URL(this._url + STORE);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer store: " + activities);
        }
        HttpURLConnection connection = (HttpURLConnection)storeUrl.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Content-Type", "application/json");
        OutputStream os = connection.getOutputStream();
        os.write(ActivityUtil.serializeActivityUnitList(activities));
        os.flush();
        os.close();
        InputStream is = connection.getInputStream();
        byte[] b = new byte[is.available()];
        is.read(b);
        is.close();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer result: " + new String(b));
        }
    }

    public ActivityUnit getActivityUnit(String id) throws Exception {
        ActivityUnit ret = null;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer getActivityUnit: " + id);
        }
        URL queryUrl = new URL(this._url + UNIT + "?id=" + id);
        HttpURLConnection connection = (HttpURLConnection)queryUrl.openConnection();
        connection.setRequestMethod("GET");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Content-Type", "application/json");
        InputStream is = connection.getInputStream();
        byte[] b = new byte[is.available()];
        is.read(b);
        is.close();
        ret = ActivityUtil.deserializeActivityUnit((byte[])b);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer getActivityUnit result: " + ret);
        }
        return ret;
    }

    public List<ActivityType> query(QuerySpec query) throws Exception {
        List ret = null;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer query: " + query);
        }
        URL queryUrl = new URL(this._url + QUERY);
        HttpURLConnection connection = (HttpURLConnection)queryUrl.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Content-Type", "application/json");
        OutputStream os = connection.getOutputStream();
        byte[] b = ActivityUtil.serializeQuerySpec((QuerySpec)query);
        os.write(b);
        os.flush();
        os.close();
        InputStream is = connection.getInputStream();
        b = new byte[is.available()];
        is.read(b);
        ret = ActivityUtil.deserializeActivityTypeList((byte[])b);
        is.close();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RESTActivityServer result: " + ret);
        }
        return ret;
    }
}

