/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.bam.activity.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.CascadeType;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.overlord.bam.activity.model.ActivityType;
import org.overlord.bam.activity.model.Context;
import org.overlord.bam.activity.model.Origin;

@Entity
@Table(name="BAM_ACTIVITY_UNITS")
public class ActivityUnit
implements Externalizable {
    private static final int VERSION = 1;
    private static final Logger LOG = Logger.getLogger(ActivityUnit.class.getName());
    private String _id = null;
    private Origin _origin = null;
    private List<ActivityType> _activityTypes = new Vector<ActivityType>();

    public ActivityUnit() {
    }

    public ActivityUnit(ActivityUnit act) {
        this._id = act._id;
        if (act._origin != null) {
            this._origin = new Origin(act._origin);
        }
        for (ActivityType actType : this._activityTypes) {
            try {
                Constructor<?> con = actType.getClass().getConstructor(actType.getClass());
                if (con != null) {
                    this._activityTypes.add((ActivityType)con.newInstance(actType));
                    continue;
                }
                LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-4"), actType.getClass().getName()));
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("activity.Messages").getString("ACTIVITY-5"), e);
            }
        }
    }

    public void setId(String id) {
        this._id = id;
    }

    @Id
    public String getId() {
        return this._id;
    }

    public void init() {
        int index = 0;
        for (ActivityType at : this.getActivityTypes()) {
            at.setUnitId(this.getId());
            at.setUnitIndex(index++);
        }
    }

    public void setOrigin(Origin origin) {
        this._origin = origin;
    }

    @Embedded
    public Origin getOrigin() {
        return this._origin;
    }

    public Set<Context> contexts() {
        HashSet<Context> ret = new HashSet<Context>();
        for (ActivityType at : this._activityTypes) {
            ret.addAll(at.getContext());
        }
        return ret;
    }

    public Map<String, String> properties() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (ActivityType at : this._activityTypes) {
            for (String key : at.getProperties().keySet()) {
                ret.put(key, at.getProperties().get(key));
            }
        }
        return ret;
    }

    public void setActivityTypes(List<ActivityType> activityTypes) {
        this._activityTypes = activityTypes;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="unitId")
    public List<ActivityType> getActivityTypes() {
        return this._activityTypes;
    }

    public String toString() {
        return "ActivityUnit[" + this._id + "] origin=" + this._origin + " activityTypes=" + this._activityTypes;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeObject(this._id);
        out.writeObject(this._origin);
        int len = this._activityTypes.size();
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            out.writeObject(this._activityTypes.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readInt();
        this._id = (String)in.readObject();
        this._origin = (Origin)in.readObject();
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            this._activityTypes.add((ActivityType)in.readObject());
        }
    }
}

