/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.common;

public class Target {
    private String name;
    private String classifier;
    private TYPE type;
    private String deployDir;
    private String user;
    private String password;
    private String rhqBaseUrl;
    private String rhqPluginName;
    private String host;
    private Integer port;
    private String mavenUrl;
    private boolean isReleaseEnabled;
    private boolean isSnapshotEnabled;
    private String description;

    public Target(String name, String classifier, String deployDir) {
        this.name = name;
        this.classifier = classifier;
        this.type = TYPE.COPY;
        this.deployDir = deployDir;
    }

    public Target(String name, String classifier, String asUser, String asPassword, String asHost, Integer asPort) {
        this.name = name;
        this.classifier = classifier;
        this.type = TYPE.AS_CLI;
        this.user = asUser;
        this.password = asPassword;
        this.host = asHost != null ? asHost : "localhost";
        this.port = this.port != null && this.port > 0 ? asPort : Integer.valueOf(9999);
    }

    public Target(String name, String classifier, String rhqUser, String rhqPassword, String rhqBaseUrl, String rhqPluginName) {
        this.name = name;
        this.classifier = classifier;
        this.type = TYPE.RHQ;
        this.user = rhqUser;
        this.password = rhqPassword;
        int secondColon = rhqBaseUrl.indexOf(":", rhqBaseUrl.indexOf(":") + 1);
        if (secondColon > 0) {
            this.rhqBaseUrl = rhqBaseUrl.substring(0, secondColon);
            String portStr = rhqBaseUrl.substring(secondColon + 1);
            int slashPosition = portStr.indexOf("/");
            if (slashPosition > 0) {
                portStr = portStr.substring(0, slashPosition);
            }
            this.port = Integer.valueOf(portStr);
        } else {
            this.rhqBaseUrl = rhqBaseUrl;
            this.port = 7080;
        }
        this.rhqPluginName = rhqPluginName;
    }

    public Target(String name, String classifier, String mavenUrl, boolean isReleaseEnabled, boolean isSnapshotEnabled) {
        this.name = name;
        this.classifier = classifier;
        this.type = TYPE.MAVEN;
        this.mavenUrl = mavenUrl;
        this.setReleaseEnabled(isReleaseEnabled);
        this.setSnapshotEnabled(isSnapshotEnabled);
    }

    public Target(String name, String classifier, String mavenUrl, String mavenUser, String mavenPassword, boolean isReleaseEnabled, boolean isSnapshotEnabled) {
        this(name, classifier, mavenUrl, isReleaseEnabled, isSnapshotEnabled);
        this.user = mavenUser;
        this.password = mavenPassword;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public TYPE getType() {
        return this.type;
    }

    public void setType(TYPE type) {
        this.type = type;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRhqBaseUrl() {
        return this.rhqBaseUrl;
    }

    public void setRhqBaseUrl(String rhqBaseUrl) {
        this.rhqBaseUrl = rhqBaseUrl;
    }

    public String getRhqPluginName() {
        return this.rhqPluginName;
    }

    public void setRhqPluginName(String rhqPluginName) {
        this.rhqPluginName = rhqPluginName;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDeployDir(String deployDir) {
        this.deployDir = deployDir;
    }

    public String getDeployDir() {
        return this.deployDir;
    }

    public String getMavenUrl() {
        return this.mavenUrl;
    }

    public void setMavenUrl(String mavenUrl) {
        this.mavenUrl = mavenUrl;
    }

    public boolean isReleaseEnabled() {
        return this.isReleaseEnabled;
    }

    public void setReleaseEnabled(boolean isReleaseEnabled) {
        this.isReleaseEnabled = isReleaseEnabled;
    }

    public boolean isSnapshotEnabled() {
        return this.isSnapshotEnabled;
    }

    public void setSnapshotEnabled(boolean isSnapshotEnabled) {
        this.isSnapshotEnabled = isSnapshotEnabled;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "Name=" + this.name + "\nDeployDir=" + this.deployDir;
    }

    public static enum TYPE {
        COPY,
        RHQ,
        AS_CLI,
        MAVEN;

    }
}

