/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.common;

public class Target {
    private String name;
    private String classifier;
    private TYPE type;
    private String deployDir;
    private String user;
    private String password;
    private String rhqBaseUrl;
    private String rhqPluginName;
    private String host;
    private Integer port;
    private String mavenUrl;
    private boolean isReleaseEnabled;
    private boolean isSnapshotEnabled;
    private boolean cliDomainMode;
    private String cliServerGroup;
    private String description;

    public static final Target copy(String name, String classifier, String deployDir) {
        Target target = new Target();
        target.name = name;
        target.classifier = classifier;
        target.type = TYPE.COPY;
        target.deployDir = deployDir;
        return target;
    }

    public static final Target cli(String name, String classifier, String asUser, String asPassword, String asHost, Integer asPort, Boolean asDomainMode, String asServerGroup) {
        Target target = new Target();
        target.name = name;
        target.classifier = classifier;
        target.type = TYPE.AS_CLI;
        target.user = asUser;
        target.password = asPassword;
        target.cliDomainMode = asDomainMode == null ? false : asDomainMode;
        target.cliServerGroup = asServerGroup;
        target.host = asHost != null ? asHost : "localhost";
        target.port = asPort != null && asPort > 0 ? asPort : Integer.valueOf(9999);
        return target;
    }

    public static final Target rhq(String name, String classifier, String rhqUser, String rhqPassword, String rhqBaseUrl, String rhqPluginName) {
        Target target = new Target();
        target.name = name;
        target.classifier = classifier;
        target.type = TYPE.RHQ;
        target.user = rhqUser;
        target.password = rhqPassword;
        int secondColon = rhqBaseUrl.indexOf(":", rhqBaseUrl.indexOf(":") + 1);
        if (secondColon > 0) {
            target.rhqBaseUrl = rhqBaseUrl.substring(0, secondColon);
            String portStr = rhqBaseUrl.substring(secondColon + 1);
            int slashPosition = portStr.indexOf("/");
            if (slashPosition > 0) {
                portStr = portStr.substring(0, slashPosition);
            }
            target.port = Integer.valueOf(portStr);
        } else {
            target.rhqBaseUrl = rhqBaseUrl;
            target.port = 7080;
        }
        target.rhqPluginName = rhqPluginName;
        return target;
    }

    public static final Target maven(String name, String classifier, String mavenUrl, boolean isReleaseEnabled, boolean isSnapshotEnabled) {
        Target target = new Target();
        target.name = name;
        target.classifier = classifier;
        target.type = TYPE.MAVEN;
        target.mavenUrl = mavenUrl;
        target.setReleaseEnabled(isReleaseEnabled);
        target.setSnapshotEnabled(isSnapshotEnabled);
        return target;
    }

    public static final Target maven(String name, String classifier, String mavenUrl, String mavenUser, String mavenPassword, boolean isReleaseEnabled, boolean isSnapshotEnabled) {
        Target target = Target.maven(name, classifier, mavenUrl, isReleaseEnabled, isSnapshotEnabled);
        target.user = mavenUser;
        target.password = mavenPassword;
        return target;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public TYPE getType() {
        return this.type;
    }

    public void setType(TYPE type) {
        this.type = type;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRhqBaseUrl() {
        return this.rhqBaseUrl;
    }

    public void setRhqBaseUrl(String rhqBaseUrl) {
        this.rhqBaseUrl = rhqBaseUrl;
    }

    public String getRhqPluginName() {
        return this.rhqPluginName;
    }

    public void setRhqPluginName(String rhqPluginName) {
        this.rhqPluginName = rhqPluginName;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDeployDir(String deployDir) {
        this.deployDir = deployDir;
    }

    public String getDeployDir() {
        return this.deployDir;
    }

    public String getMavenUrl() {
        return this.mavenUrl;
    }

    public void setMavenUrl(String mavenUrl) {
        this.mavenUrl = mavenUrl;
    }

    public boolean isReleaseEnabled() {
        return this.isReleaseEnabled;
    }

    public void setReleaseEnabled(boolean isReleaseEnabled) {
        this.isReleaseEnabled = isReleaseEnabled;
    }

    public boolean isSnapshotEnabled() {
        return this.isSnapshotEnabled;
    }

    public void setSnapshotEnabled(boolean isSnapshotEnabled) {
        this.isSnapshotEnabled = isSnapshotEnabled;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "Name=" + this.name + "\nDeployDir=" + this.deployDir;
    }

    public boolean isCliDomainMode() {
        return this.cliDomainMode;
    }

    public void setCliDomainMode(boolean cliDomainMode) {
        this.cliDomainMode = cliDomainMode;
    }

    public String getCliServerGroup() {
        return this.cliServerGroup;
    }

    public void setCliServerGroup(String cliServerGroup) {
        this.cliServerGroup = cliServerGroup;
    }

    public static enum TYPE {
        COPY,
        RHQ,
        AS_CLI,
        MAVEN;

    }
}

