/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.common;

import java.util.Map;
import org.overlord.dtgov.common.targets.CliTarget;
import org.overlord.dtgov.common.targets.CopyTarget;
import org.overlord.dtgov.common.targets.CustomTarget;
import org.overlord.dtgov.common.targets.MavenTarget;
import org.overlord.dtgov.common.targets.RHQTarget;

public abstract class Target {
    private String name;
    private String classifier;
    private TYPE type;
    private String description;

    public static final Target copy(String name, String classifier, String deployDir) {
        return CopyTarget.getTarget(name, classifier, deployDir);
    }

    public static final Target cli(String name, String classifier, String asUser, String asPassword, String asHost, Integer asPort, Boolean asDomainMode, String asServerGroup) {
        return CliTarget.getTarget(name, classifier, asUser, asPassword, asHost, asPort, asDomainMode, asServerGroup);
    }

    public static final Target rhq(String name, String classifier, String rhqUser, String rhqPassword, String rhqBaseUrl, String rhqPluginName, String rhqGroup) {
        return RHQTarget.getTarget(name, classifier, rhqUser, rhqPassword, rhqBaseUrl, rhqPluginName, rhqGroup);
    }

    public static final Target maven(String name, String classifier, String mavenUrl, boolean isReleaseEnabled, boolean isSnapshotEnabled) {
        return MavenTarget.getTarget(name, classifier, mavenUrl, isReleaseEnabled, isSnapshotEnabled);
    }

    public static final Target custom(String name, String classifier, String customType, Map<String, String> properties) {
        return CustomTarget.getTarget(name, classifier, customType, properties);
    }

    public static final Target maven(String name, String classifier, String mavenUrl, String mavenUser, String mavenPassword, boolean isReleaseEnabled, boolean isSnapshotEnabled) {
        return MavenTarget.getTarget(name, classifier, mavenUrl, isReleaseEnabled, isSnapshotEnabled);
    }

    public Target(String name, String classifier, TYPE type) {
        this.name = name;
        this.classifier = classifier;
        this.type = type;
    }

    public TYPE getType() {
        return this.type;
    }

    public void setType(TYPE type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static enum TYPE {
        COPY,
        RHQ,
        AS_CLI,
        MAVEN,
        CUSTOM;

    }
}

