/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.common.targets;

import java.io.Serializable;
import org.overlord.dtgov.common.Target;

public class CliTarget
extends Target
implements Serializable {
    private static final long serialVersionUID = -4323018470513316694L;
    private String user;
    private String password;
    private boolean domainMode;
    private String serverGroup;
    private String host;
    private Integer port;

    public CliTarget(String name, String classifier, String user, String password, boolean domainMode, String serverGroup, String host, Integer port) {
        super(name, classifier, Target.TYPE.AS_CLI);
        this.user = user;
        this.password = password;
        this.domainMode = domainMode;
        this.serverGroup = serverGroup;
        this.host = host;
        this.port = port;
    }

    public CliTarget(String name, String classifier) {
        super(name, classifier, Target.TYPE.AS_CLI);
    }

    public static final Target getTarget(String name, String classifier, String asUser, String asPassword, String asHost, Integer asPort, Boolean asDomainMode, String asServerGroup) {
        CliTarget target = new CliTarget(name, classifier);
        target.setUser(asUser);
        target.setPassword(asPassword);
        if (asDomainMode == null) {
            target.setDomainMode(false);
        } else {
            target.setDomainMode(asDomainMode);
        }
        target.setServerGroup(asServerGroup);
        if (asHost != null) {
            target.setHost(asHost);
        } else {
            target.setHost("localhost");
        }
        if (asPort != null && asPort > 0) {
            target.setPort(asPort);
        } else {
            target.setPort(9999);
        }
        return target;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isDomainMode() {
        return this.domainMode;
    }

    public void setDomainMode(boolean domainMode) {
        this.domainMode = domainMode;
    }

    public String getServerGroup() {
        return this.serverGroup;
    }

    public void setServerGroup(String serverGroup) {
        this.serverGroup = serverGroup;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }
}

