/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.common.targets;

import java.io.Serializable;
import java.util.Map;
import org.overlord.dtgov.common.Target;

public class CustomTarget
extends Target
implements Serializable {
    private static final long serialVersionUID = -8298937126180266707L;
    private String customType;
    Map<String, String> properties;

    public CustomTarget(String name, String classifier, String customType, Map<String, String> properties) {
        super(name, classifier, Target.TYPE.CUSTOM);
        this.customType = customType;
        this.properties = properties;
    }

    public CustomTarget(String name, String classifier) {
        super(name, classifier, Target.TYPE.CUSTOM);
    }

    public static final Target getTarget(String name, String classifier, String customType, Map<String, String> properties) {
        CustomTarget target = new CustomTarget(name, classifier);
        target.customType = customType;
        target.properties = properties;
        return target;
    }

    public String getCustomType() {
        return this.customType;
    }

    public void setCustomType(String customType) {
        this.customType = customType;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getProperty(String key) {
        if (this.properties != null && !this.properties.isEmpty()) {
            if (this.properties.containsKey(key)) {
                return this.properties.get(key);
            }
            String key_prefixed = "deployment.custom.property." + key;
            if (this.properties.containsKey(key_prefixed)) {
                return this.properties.get(key_prefixed);
            }
        }
        return null;
    }
}

