/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.common.targets;

import java.io.Serializable;
import org.overlord.dtgov.common.Target;

public class RHQTarget
extends Target
implements Serializable {
    private static final long serialVersionUID = 4387955655881622176L;
    private String user;
    private String password;
    private String baseUrl;
    private String pluginName;
    private String group;
    private Integer port;

    public RHQTarget(String name, String classifier, String user, String password, String baseUrl, String pluginName, String group) {
        super(name, classifier, Target.TYPE.RHQ);
        this.user = user;
        this.password = password;
        this.baseUrl = baseUrl;
        this.pluginName = pluginName;
        this.group = group;
    }

    public RHQTarget(String name, String classifier) {
        super(name, classifier, Target.TYPE.RHQ);
    }

    public static final Target getTarget(String name, String classifier, String rhqUser, String rhqPassword, String rhqBaseUrl, String rhqPluginName, String rhqGroup) {
        RHQTarget target = new RHQTarget(name, classifier);
        target.user = rhqUser;
        target.password = rhqPassword;
        int secondColon = rhqBaseUrl.indexOf(":", rhqBaseUrl.indexOf(":") + 1);
        if (secondColon > 0) {
            target.baseUrl = rhqBaseUrl.substring(0, secondColon);
            String portStr = rhqBaseUrl.substring(secondColon + 1);
            int slashPosition = portStr.indexOf("/");
            if (slashPosition > 0) {
                portStr = portStr.substring(0, slashPosition);
            }
            target.port = Integer.valueOf(portStr);
        } else {
            target.baseUrl = rhqBaseUrl;
            target.port = 7080;
        }
        target.pluginName = rhqPluginName;
        target.group = rhqGroup;
        return target;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }
}

