/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance;

import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Named;
import org.apache.commons.codec.digest.DigestUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.overlord.dtgov.common.exception.ConfigException;
import org.overlord.dtgov.server.i18n.Messages;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.governance.Governance;
import org.overlord.sramp.governance.Query;
import org.overlord.sramp.governance.QueryAccessor;
import org.overlord.sramp.governance.SrampAtomApiClientFactory;
import org.overlord.sramp.governance.WorkflowAccesor;
import org.overlord.sramp.governance.workflow.BpmManager;
import org.overlord.sramp.governance.workflow.WorkflowFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Named
@RequestScoped
public class QueryExecutor {
    private static String GROUPED_BY = "groupedBy";
    private static Logger logger = LoggerFactory.getLogger(QueryExecutor.class);
    private static String MAVEN_PROPERTY_SIGNAL = "maven.property.signal";
    private static String SIGNAL_QUERY = "/s-ramp/ext/MavenPom[@maven.property.signal]";

    public static synchronized void execute() throws SrampClientException, MalformedURLException, ConfigException {
        Governance governance = new Governance();
        String deploymentId = governance.getGovernanceWorkflowGroup() + ":" + governance.getGovernanceWorkflowName() + ":" + governance.getGovernanceWorkflowVersion() + ":" + Governance.DEFAULT_GOVERNANCE_WORKFLOW_PACKAGE + ":" + Governance.DEFAULT_GOVERNANCE_WORKFLOW_KSESSION;
        BpmManager bpmManager = WorkflowFactory.newInstance();
        SrampAtomApiClient client = SrampAtomApiClientFactory.createAtomApiClient();
        QueryAccessor accesor = new QueryAccessor();
        WorkflowAccesor workflowAccesor = new WorkflowAccesor();
        for (Query query : accesor.getQueries()) {
            try {
                String srampQuery = query.getSrampQuery();
                QueryResultSet queryResultSet = client.query(srampQuery);
                if (queryResultSet.size() <= 0L) continue;
                for (ArtifactSummary artifactSummary : queryResultSet) {
                    boolean workflowAlreadyCreated = false;
                    if (workflowAccesor.existRunningWorkflow(artifactSummary.getUuid(), artifactSummary.getName(), query.getWorkflowId(), null, query.getParameters())) {
                        workflowAlreadyCreated = true;
                    }
                    if (workflowAlreadyCreated) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug(Messages.i18n.format("QueryExecutor.ExistingWorkflowError", new Object[]{artifactSummary.getUuid(), query.getWorkflowId(), query.getParameters()}));
                        continue;
                    }
                    String hashGuid = QueryExecutor.createWorkflowArtifactGuid((String)artifactSummary.getUuid(), (String)query.getWorkflowId());
                    BaseArtifactType workflowArtifact = workflowAccesor.save(hashGuid, artifactSummary.getUuid(), artifactSummary.getName(), query.getWorkflowId(), query.getParameters());
                    BaseArtifactType artifact = client.getArtifactMetaData(artifactSummary.getType(), artifactSummary.getUuid());
                    logger.info(Messages.i18n.format("QueryExecutor.StartingWorkflow", new Object[]{query.getWorkflowId(), artifact.getUuid()}));
                    Map parameters = query.getParsedParameters();
                    parameters.put("ArtifactUuid", artifact.getUuid());
                    parameters.put("ArtifactName", artifact.getName());
                    if (artifact.getVersion() != null) {
                        parameters.put("ArtifactVersion", artifact.getVersion());
                    }
                    parameters.put("ArtifactCreatedBy", artifact.getCreatedBy());
                    parameters.put("ArtifactCreatedTimestamp", artifact.getCreatedTimestamp().toGregorianCalendar());
                    parameters.put("ArtifactLastModifiedBy", artifact.getLastModifiedBy());
                    parameters.put("ArtifactLastModifiedTimestamp", artifact.getLastModifiedTimestamp().toGregorianCalendar());
                    parameters.put("ArtifactType", artifactSummary.getType().getType());
                    long processInstanceId = bpmManager.newProcessInstance(deploymentId, query.getWorkflowId(), parameters);
                    workflowAccesor.update(workflowArtifact, processInstanceId);
                }
            }
            catch (Exception e) {
                logger.error(Messages.i18n.format("QueryExecutor.ExceptionFor", new Object[]{query.getSrampQuery(), e.getMessage()}), (Throwable)e);
            }
        }
        try {
            QueryResultSet queryResultSet = client.query(SIGNAL_QUERY);
            if (queryResultSet.size() > 0L) {
                for (ArtifactSummary artifactSummary : queryResultSet) {
                    BaseArtifactType pomArtifact = client.getArtifactMetaData(artifactSummary.getType(), artifactSummary.getUuid());
                    for (Relationship relationship : pomArtifact.getRelationship()) {
                        if (!GROUPED_BY.equals(relationship.getRelationshipType())) continue;
                        for (Target target : relationship.getRelationshipTarget()) {
                            List processesIds = workflowAccesor.getProcessIds(target.getValue());
                            block9: for (Long processId : processesIds) {
                                for (Property signalProperty : pomArtifact.getProperty()) {
                                    if (!signalProperty.getPropertyName().equals(MAVEN_PROPERTY_SIGNAL)) continue;
                                    String signalType = signalProperty.getPropertyValue();
                                    bpmManager.signalProcess(processId.longValue(), signalType, (Object)pomArtifact.getUuid());
                                    signalProperty.setPropertyName(MAVEN_PROPERTY_SIGNAL + ".sent");
                                    client.updateArtifactMetaData(pomArtifact);
                                    continue block9;
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(Messages.i18n.format("QueryExecutor.ExceptionFor", new Object[]{SIGNAL_QUERY, e.getMessage()}), (Throwable)e);
        }
    }

    private static String createWorkflowArtifactGuid(String uuid, String workflowId) {
        String value = uuid + "||" + workflowId;
        return DigestUtils.shaHex((String)value);
    }
}

