/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.jbpm.util;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Alternative;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.kie.internal.task.api.UserGroupCallback;
import org.overlord.commons.auth.filters.HttpRequestThreadLocalFilter;
import org.overlord.commons.auth.filters.SamlBearerTokenAuthFilter;
import org.overlord.commons.auth.filters.SimplePrincipal;
import org.overlord.commons.auth.jetty8.JettyAuthConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alternative
public class DTGovUserGroupCallbackJetty
implements UserGroupCallback {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public boolean existsUser(String userId) {
        return true;
    }

    public boolean existsGroup(String groupId) {
        return true;
    }

    public List<String> getGroupsForUser(String userId, List<String> groupIds, List<String> allExistingGroupIds) {
        SimplePrincipal sp = (SimplePrincipal)SamlBearerTokenAuthFilter.TL_principal.get();
        if (sp != null) {
            return new ArrayList<String>(sp.getRoles());
        }
        ArrayList<String> roles = new ArrayList<String>();
        try {
            HttpServletRequest request = (HttpServletRequest)HttpRequestThreadLocalFilter.TL_request.get();
            Request jettyRequest = (Request)request;
            Authentication authentication = jettyRequest.getAuthentication();
            Authentication.User userAuth = (Authentication.User)authentication;
            UserIdentity userIdentity = userAuth.getUserIdentity();
            Subject subject = userIdentity.getSubject();
            for (String cname : JettyAuthConstants.ROLE_CLASSES) {
                try {
                    Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(cname);
                    Set<?> principals = subject.getPrincipals(c);
                    for (Principal p : principals) {
                        roles.add(p.getName());
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            return roles;
        }
        catch (Exception e) {
            this.logger.error("ErrorGettingRoles for user " + userId, (Throwable)e);
            return roles;
        }
    }
}

