/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.taskapi;

import java.security.Principal;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.OptimisticLockException;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.RollbackException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.TaskSummary;
import org.kie.api.task.model.User;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.overlord.dtgov.jbpm.ProcessOperationException;
import org.overlord.dtgov.jbpm.util.KieSrampUtil;
import org.overlord.dtgov.jbpm.util.ProcessEngineService;
import org.overlord.dtgov.server.i18n.Messages;
import org.overlord.dtgov.taskapi.TaskSummaryComparator;
import org.overlord.dtgov.taskapi.types.FindTasksRequest;
import org.overlord.dtgov.taskapi.types.FindTasksResponse;
import org.overlord.dtgov.taskapi.types.StatusType;
import org.overlord.dtgov.taskapi.types.TaskDataType;
import org.overlord.dtgov.taskapi.types.TaskSummaryType;
import org.overlord.dtgov.taskapi.types.TaskType;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.governance.Governance;
import org.overlord.sramp.governance.SrampMavenUtil;

@ApplicationScoped
@Transactional
@Path(value="/tasks")
public class TaskApi {
    private static Boolean hasSRAMPPackageDeployed = Boolean.FALSE;
    private static final String SRAMP_KIE_MODEL = "/s-ramp/ext/KieJarArchive";
    @Inject
    TaskService taskService;
    @Inject
    @ApplicationScoped
    private ProcessEngineService processEngineService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void configure() {
        Boolean bl = hasSRAMPPackageDeployed;
        synchronized (bl) {
            KieSrampUtil kieSrampUtil = new KieSrampUtil();
            Governance governance = new Governance();
            String groupId = governance.getGovernanceWorkflowGroup();
            String artifactId = governance.getGovernanceWorkflowName();
            String workflowVersion = governance.getGovernanceWorkflowVersion();
            String version = null;
            try {
                version = SrampMavenUtil.getVersion((String)SRAMP_KIE_MODEL, (String)groupId, (String)artifactId, (String)workflowVersion);
            }
            catch (SrampClientException e) {
                throw new RuntimeException(Messages.i18n.format("maven.version.not.found.error", new Object[]{groupId, artifactId, workflowVersion}), e);
            }
            catch (SrampAtomException e) {
                throw new RuntimeException(Messages.i18n.format("maven.version.not.found.error", new Object[]{groupId, artifactId, workflowVersion}), e);
            }
            if (StringUtils.isBlank((String)version)) {
                throw new RuntimeException(Messages.i18n.format("maven.version.not.found", new Object[]{groupId, artifactId, workflowVersion}));
            }
            if (kieSrampUtil.isSRAMPPackageDeployed(groupId, artifactId, version)) {
                KModuleDeploymentUnit unit = new KModuleDeploymentUnit(groupId, artifactId, version, Governance.DEFAULT_GOVERNANCE_WORKFLOW_PACKAGE, Governance.DEFAULT_GOVERNANCE_WORKFLOW_KSESSION);
                RuntimeManager runtimeManager = kieSrampUtil.getRuntimeManager(this.processEngineService, unit);
                RuntimeEngine runtime = runtimeManager.getRuntimeEngine(EmptyContext.get());
                runtime.getTaskService().toString();
            }
        }
    }

    @GET
    @Path(value="list")
    @Produces(value={"application/xml"})
    public FindTasksResponse listTasks(@Context HttpServletRequest httpRequest, @QueryParam(value="startIndex") Integer startIndex, @QueryParam(value="endIndex") Integer endIndex, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="orderAscending") Boolean orderAscending, @QueryParam(value="status") String status, @QueryParam(value="priority") Integer priority) throws Exception {
        FindTasksRequest findTasksReq = new FindTasksRequest();
        findTasksReq.setStartIndex(Integer.valueOf(0));
        if (startIndex != null) {
            findTasksReq.setStartIndex(startIndex);
        }
        findTasksReq.setEndIndex(Integer.valueOf(19));
        if (endIndex != null) {
            findTasksReq.setEndIndex(endIndex);
        }
        findTasksReq.setOrderBy("priority");
        if (orderBy != null) {
            findTasksReq.setOrderBy(orderBy);
        }
        findTasksReq.setOrderAscending(Boolean.valueOf(false));
        if (orderAscending != null) {
            findTasksReq.setOrderAscending(orderAscending);
        }
        findTasksReq.getPriority().clear();
        if (priority != null) {
            findTasksReq.getPriority().add(priority);
        }
        findTasksReq.getStatus().clear();
        if (status != null) {
            findTasksReq.getStatus().add(StatusType.fromValue((String)status));
        }
        return this.findTasks(findTasksReq, httpRequest);
    }

    @POST
    @Path(value="find")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public FindTasksResponse findTasks(FindTasksRequest findTasksRequest, @Context HttpServletRequest httpRequest) throws Exception {
        String currentUser = this.assertCurrentUser(httpRequest);
        FindTasksResponse response = new FindTasksResponse();
        String language = "en-UK";
        List list = this.taskService.getTasksAssignedAsPotentialOwner(currentUser, language);
        list.addAll(this.taskService.getTasksOwned(currentUser, language));
        String orderBy = findTasksRequest.getOrderBy() == null ? "priority" : findTasksRequest.getOrderBy();
        boolean ascending = findTasksRequest.isOrderAscending();
        TreeSet<TaskSummary> sortedFiltered = new TreeSet<TaskSummary>((Comparator<TaskSummary>)new TaskSummaryComparator(orderBy, ascending));
        for (TaskSummary task : list) {
            if (!this.accepts(task, findTasksRequest)) continue;
            sortedFiltered.add(task);
        }
        int startIdx = findTasksRequest.getStartIndex();
        int endIdx = findTasksRequest.getEndIndex();
        int idx = 0;
        for (TaskSummary task : sortedFiltered) {
            if (idx >= startIdx && idx <= endIdx) {
                TaskSummaryType taskSummary = new TaskSummaryType();
                taskSummary.setId(String.valueOf(task.getId()));
                taskSummary.setName(task.getName());
                User actualOwner = task.getActualOwner();
                if (actualOwner != null) {
                    taskSummary.setOwner(actualOwner.getId());
                }
                taskSummary.setPriority(task.getPriority().intValue());
                taskSummary.setStatus(StatusType.fromValue((String)task.getStatus().toString()));
                response.getTaskSummary().add(taskSummary);
            }
            ++idx;
        }
        response.setTotalResults((long)sortedFiltered.size());
        return response;
    }

    @GET
    @Path(value="get/{taskId}")
    @Produces(value={"application/xml"})
    public TaskType getTask(@Context HttpServletRequest httpRequest, @PathParam(value="taskId") long taskId) throws Exception {
        Content content;
        Map inputParams;
        long docId;
        List names;
        this.assertCurrentUser(httpRequest);
        Task task = this.taskService.getTaskById(taskId);
        TaskType rval = new TaskType();
        List descriptions = task.getDescriptions();
        if (descriptions != null && !descriptions.isEmpty()) {
            rval.setDescription(((I18NText)descriptions.iterator().next()).getText());
        }
        if ((names = task.getNames()) != null && !names.isEmpty()) {
            rval.setName(((I18NText)names.iterator().next()).getText());
        }
        rval.setPriority(task.getPriority());
        rval.setId(String.valueOf(task.getId()));
        rval.setType(task.getTaskType());
        TaskData taskData = task.getTaskData();
        if (taskData != null) {
            Date expTime;
            User owner = taskData.getActualOwner();
            if (owner != null) {
                rval.setOwner(owner.getId());
            }
            if ((expTime = taskData.getExpirationTime()) != null) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(expTime);
                DatatypeFactory dtFactory = DatatypeFactory.newInstance();
                rval.setDueDate(dtFactory.newXMLGregorianCalendar(cal));
            }
            rval.setStatus(StatusType.fromValue((String)taskData.getStatus().toString()));
        }
        if ((docId = this.taskService.getTaskById(taskId).getTaskData().getDocumentContentId()) > 0L && (inputParams = (Map)ContentMarshallerHelper.unmarshall((byte[])(content = this.taskService.getContentById(docId)).getContent(), null)) != null && inputParams.size() > 0) {
            if (rval.getTaskData() == null) {
                rval.setTaskData(new TaskDataType());
            }
            for (String key : inputParams.keySet()) {
                TaskDataType.Entry entry = new TaskDataType.Entry();
                entry.setKey(key);
                entry.setValue(String.valueOf(inputParams.get(key)));
                rval.getTaskData().getEntry().add(entry);
            }
        }
        return rval;
    }

    @GET
    @Path(value="claim/{taskId}")
    @Produces(value={"application/xml"})
    public TaskType claimTask(@Context HttpServletRequest httpRequest, @PathParam(value="taskId") long taskId) throws Exception {
        String currentUser = this.assertCurrentUser(httpRequest);
        try {
            this.taskService.claim(taskId, currentUser);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.getTask(httpRequest, taskId);
    }

    @GET
    @Path(value="release/{taskId}")
    @Produces(value={"application/xml"})
    public TaskType releaseTask(@Context HttpServletRequest httpRequest, @PathParam(value="taskId") long taskId) throws Exception {
        String currentUser = this.assertCurrentUser(httpRequest);
        try {
            this.taskService.release(taskId, currentUser);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.getTask(httpRequest, taskId);
    }

    @GET
    @Path(value="start/{taskId}")
    @Produces(value={"application/xml"})
    public TaskType startTask(@Context HttpServletRequest httpRequest, @PathParam(value="taskId") long taskId) throws Exception {
        String currentUser = this.assertCurrentUser(httpRequest);
        try {
            this.taskService.start(taskId, currentUser);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.getTask(httpRequest, taskId);
    }

    @GET
    @Path(value="stop/{taskId}")
    @Produces(value={"application/xml"})
    public TaskType stopTask(@Context HttpServletRequest httpRequest, @PathParam(value="taskId") long taskId) throws Exception {
        String currentUser = this.assertCurrentUser(httpRequest);
        try {
            this.taskService.stop(taskId, currentUser);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.getTask(httpRequest, taskId);
    }

    @POST
    @Path(value="complete/{taskId}")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public TaskType completeTask(TaskDataType taskData, @Context HttpServletRequest httpRequest, @PathParam(value="taskId") long taskId) throws Exception {
        String currentUser = this.assertCurrentUser(httpRequest);
        try {
            Map data = this.taskDataAsMap(taskData);
            this.taskService.complete(taskId, currentUser, data);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.getTask(httpRequest, taskId);
    }

    @POST
    @Path(value="fail/{taskId}")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public TaskType failTask(TaskDataType taskData, @Context HttpServletRequest httpRequest, @PathParam(value="taskId") long taskId) throws Exception {
        String currentUser = this.assertCurrentUser(httpRequest);
        try {
            Map data = this.taskDataAsMap(taskData);
            this.taskService.fail(taskId, currentUser, data);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.getTask(httpRequest, taskId);
    }

    private Map<String, Object> taskDataAsMap(TaskDataType taskData) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (TaskDataType.Entry entry : taskData.getEntry()) {
            data.put(entry.getKey(), entry.getValue());
        }
        return data;
    }

    protected void handleException(Exception error) throws Exception {
        if (error instanceof RollbackException) {
            Throwable cause = error.getCause();
            if (cause != null && cause instanceof OptimisticLockException) {
                throw new ProcessOperationException(Messages.i18n.format("TaskApi.ConcurrentTaskAccessError", new Object[0]), (Throwable)error);
            }
            throw error;
        }
        if (error instanceof PermissionDeniedException) {
            throw new ProcessOperationException(Messages.i18n.format("TaskApi.AlreadyClaimed", new Object[0]), (Throwable)error);
        }
        throw error;
    }

    protected String assertCurrentUser(HttpServletRequest httpRequest) throws Exception {
        Principal principal = httpRequest.getUserPrincipal();
        if (principal == null) {
            throw new Exception(Messages.i18n.format("TaskApi.NoAuthError", new Object[0]));
        }
        return principal.getName();
    }

    private boolean accepts(TaskSummary task, FindTasksRequest findTasksRequest) {
        XMLGregorianCalendar to;
        HashSet priorities = new HashSet(findTasksRequest.getPriority());
        HashSet statuses = new HashSet(findTasksRequest.getStatus());
        if (!priorities.isEmpty() && !priorities.contains(task.getPriority())) {
            return false;
        }
        if (!statuses.isEmpty() && !statuses.contains(StatusType.fromValue((String)task.getStatus().toString()))) {
            return false;
        }
        XMLGregorianCalendar from = findTasksRequest.getDueOnFrom();
        if (from != null) {
            Date expirationTime = task.getExpirationTime();
            if (expirationTime == null) {
                return false;
            }
            if (expirationTime.compareTo(from.toGregorianCalendar().getTime()) < 0) {
                return false;
            }
        }
        if ((to = findTasksRequest.getDueOnTo()) != null) {
            Date expirationTime = task.getExpirationTime();
            if (expirationTime == null) {
                return false;
            }
            if (expirationTime.compareTo(to.toGregorianCalendar().getTime()) > 0) {
                return false;
            }
        }
        return true;
    }
}

