/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.jbpm.util;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.inject.Alternative;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Role;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.users.MemoryUser;
import org.kie.internal.task.api.UserGroupCallback;
import org.overlord.commons.auth.tomcat7.HttpRequestThreadLocalValve;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alternative
public class DTGovUserGroupCallbackTomcat
implements UserGroupCallback {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public boolean existsUser(String userId) {
        return true;
    }

    public boolean existsGroup(String groupId) {
        return true;
    }

    public List<String> getGroupsForUser(String userId, List<String> groupIds, List<String> allExistingGroupIds) {
        ArrayList<String> roles = null;
        try {
            HttpServletRequest request = (HttpServletRequest)HttpRequestThreadLocalValve.TL_request.get();
            Principal principal = request.getUserPrincipal();
            if (principal instanceof GenericPrincipal) {
                GenericPrincipal gp = (GenericPrincipal)principal;
                String[] gpRoles = gp.getRoles();
                roles = new ArrayList<String>(gpRoles.length);
                for (String role : gpRoles) {
                    roles.add(role);
                }
            } else if (principal instanceof MemoryUser) {
                MemoryUser mu = (MemoryUser)principal;
                Iterator iter = mu.getRoles();
                roles = new ArrayList();
                while (iter.hasNext()) {
                    roles.add(((Role)iter.next()).getRolename());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("ErrorGettingRoles for user " + userId, (Throwable)e);
        }
        return roles;
    }
}

