/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.jbpm.ejb;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.transaction.UserTransaction;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.internal.runtime.manager.cdi.qualifier.Singleton;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.overlord.dtgov.jbpm.ejb.ProcessLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@TransactionManagement(value=TransactionManagementType.BEAN)
public class ProcessBean
implements ProcessLocal {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private UserTransaction ut;
    @Inject
    @Singleton
    RuntimeManager singletonManager;
    @Inject
    TaskService taskService;

    @Override
    public long startProcess(String processId, Map<String, Object> parameters) throws Exception {
        RuntimeEngine runtime = this.singletonManager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        long processInstanceId = -1L;
        this.ut.begin();
        try {
            ProcessInstance processInstance = ksession.startProcess(processId, parameters);
            processInstanceId = processInstance.getId();
            this.logger.info("Process started ... : processInstanceId = " + processInstanceId);
            this.ut.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.ut.getStatus() == 0) {
                this.ut.rollback();
            }
            throw e;
        }
        return processInstanceId;
    }

    @Override
    public Collection<ProcessInstance> listProcessInstances() throws Exception {
        RuntimeEngine runtime = this.singletonManager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        Collection processInstances = null;
        this.ut.begin();
        try {
            processInstances = ksession.getProcessInstances();
            for (ProcessInstance processInstance : processInstances) {
                this.logger.info(processInstance.getProcess().getName());
                System.out.println("..");
            }
            this.ut.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.ut.getStatus() == 0) {
                this.ut.rollback();
            }
            throw e;
        }
        finally {
            ksession.dispose();
        }
        return processInstances;
    }

    @Override
    public void listProcessInstanceDetail(long processId) throws Exception {
        RuntimeEngine runtime = this.singletonManager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        this.logger.info("ksession=" + ksession);
        this.ut.begin();
        try {
            ProcessInstance processInstance = ksession.getProcessInstance(processId);
            if (processInstance != null) {
                System.out.println(processInstance.getProcess().getName());
                System.out.println(processInstance.getState());
                System.out.println("..");
            }
            this.ut.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.ut.getStatus() == 0) {
                this.ut.rollback();
            }
            throw e;
        }
    }
}

