/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.jbpm.util;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceUnit;
import org.apache.maven.project.MavenProject;
import org.jbpm.runtime.manager.impl.RuntimeEnvironmentBuilder;
import org.jbpm.runtime.manager.impl.cdi.InjectableRegisterableItemsFactory;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.runtime.manager.RegisterableItemsFactory;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.cdi.qualifier.PerProcessInstance;
import org.kie.internal.runtime.manager.cdi.qualifier.PerRequest;
import org.kie.internal.runtime.manager.cdi.qualifier.Singleton;
import org.kie.internal.task.api.UserGroupCallback;
import org.overlord.dtgov.jbpm.util.KieUtil;
import org.overlord.dtgov.jbpm.util.MavenRepository;
import org.overlord.sramp.governance.Governance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.artifact.Artifact;

@ApplicationScoped
public class ApplicationScopedProducer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private InjectableRegisterableItemsFactory factory;
    @Inject
    private UserGroupCallback usergroupCallback;
    @PersistenceUnit(unitName="org.overlord.dtgov.jbpm")
    private EntityManagerFactory emf;

    @Produces
    public UserGroupCallback produceUserGroupCallback() {
        return this.usergroupCallback;
    }

    @Produces
    public EntityManagerFactory produceEntityManagerFactory() {
        if (this.emf == null) {
            this.emf = Persistence.createEntityManagerFactory((String)"org.overlord.dtgov.jbpm");
        }
        return this.emf;
    }

    @Produces
    @Singleton
    @PerProcessInstance
    @PerRequest
    public RuntimeEnvironment produceEnvironment(EntityManagerFactory emf) {
        RuntimeEnvironmentBuilder builder = RuntimeEnvironmentBuilder.getDefault().entityManagerFactory(emf).userGroupCallback(this.usergroupCallback).registerableItemsFactory((RegisterableItemsFactory)this.factory);
        KieBase kbase = this.getKieBase();
        if (kbase != null) {
            builder.knowledgeBase(this.getKieBase());
        }
        return builder.get();
    }

    private KieBase getKieBase() {
        Governance governance = new Governance();
        try {
            String srampUrl = governance.getSrampUrl().toExternalForm();
            srampUrl = "sramp" + srampUrl.substring(srampUrl.indexOf(":"));
            KieServices ks = KieServices.Factory.get();
            MavenProject srampProject = KieUtil.getSrampProject(governance.getSrampWagonVersion(), srampUrl, governance.getSrampWagonSnapshots(), governance.getSrampWagonReleases());
            MavenRepository repo = MavenRepository.getMavenRepository(srampProject);
            ReleaseId releaseId = ks.newReleaseId(governance.getGovernanceWorkflowGroup(), governance.getGovernanceWorkflowName(), governance.getGovernanceWorkflowVersion());
            Artifact artifact = repo.resolveArtifact(releaseId.toExternalForm());
            this.logger.info("Creating KIE container with workflows from " + artifact);
            KieContainer kieContainer = ks.newKieContainer(releaseId);
            this.logger.info("Looking for KieBase named " + governance.getGovernanceWorkflowPackage());
            KieBase kbase = kieContainer.getKieBase(governance.getGovernanceWorkflowPackage());
            return kbase;
        }
        catch (Exception e) {
            this.logger.error("Could not find or read the " + governance.getGovernanceWorkflowPackage());
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

