/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.overlord.sramp.governance.ConfigException;
import org.overlord.sramp.governance.NotificationDestinations;
import org.overlord.sramp.governance.Query;
import org.overlord.sramp.governance.Release;
import org.overlord.sramp.governance.Target;
import org.overlord.sramp.governance.auth.BasicAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Governance {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static String QUERY_ERROR = "governance.queries should be of the format <query>|<processId>|<param::param>\nCheck\n";
    public static String TARGET_ERROR = "governance.targets should be of the format <targetName>|<directory>\nCheck\n";
    public static String NOTIFICATION_ERROR = "governance..<email|..> should be of the format <groupName>|<fromAddress>|<destination1>,<destination2>\nCheck\n";
    public static String DEFAULT_JNDI_EMAIL_REF = "java:jboss/mail/Default";
    public static String DEFAULT_EMAIL_DOMAIN = "example.com";
    public static String DEFAULT_EMAIL_FROM = "overlord@example.org";
    public static String DEFAULT_GOVERNANCE_WORKFLOW_GROUP = "org.overlord.dtgov";
    public static String DEFAULT_GOVERNANCE_WORKFLOW_NAME = "dtgov-workflows";
    public static String DEFAULT_GOVERNANCE_WORKFLOW_VERSION = "1.0.0";
    public static String DEFAULT_GOVERNANCE_WORKFLOW_PACKAGE = "SRAMPPackage";
    public static String DEFAULT_GOVERNANCE_USER = "admin";
    public static String DEFAULT_GOVERNANCE_PASSWORD = "overlord";
    public static String DEFAULT_RHQ_USER = "rhqadmin";
    public static String DEFAULT_RHQ_PASSWORD = "rhqadmin";
    public static String DEFAULT_RHQ_BASEURL = "http://localhost:7080";
    private static CompositeConfiguration configuration = new CompositeConfiguration();

    private static URL findDtgovConfig(String configFile) {
        try {
            if (configFile != null) {
                URL fromClasspath = Governance.class.getClassLoader().getResource(configFile);
                if (fromClasspath != null) {
                    return fromClasspath;
                }
                File file = new File(configFile);
                if (file.isFile()) {
                    return file.toURI().toURL();
                }
            } else {
                File cfile;
                File dirFile;
                File cfile2;
                File dirFile2;
                File cfile3;
                File dirFile3;
                String userHomeDir = System.getProperty("user.home");
                if (userHomeDir != null && (dirFile3 = new File(userHomeDir)).isDirectory() && (cfile3 = new File(dirFile3, "dtgov.properties")).isFile()) {
                    return cfile3.toURI().toURL();
                }
                String jbossConfigDir = System.getProperty("jboss.server.config.dir");
                if (jbossConfigDir != null && (dirFile2 = new File(jbossConfigDir)).isDirectory() && (cfile2 = new File(dirFile2, "dtgov.properties")).isFile()) {
                    return cfile2.toURI().toURL();
                }
                String jbossConfigUrl = System.getProperty("jboss.server.config.url");
                if (jbossConfigUrl != null && (dirFile = new File(jbossConfigUrl)).isDirectory() && (cfile = new File(dirFile, "dtgov.properties")).isFile()) {
                    return cfile.toURI().toURL();
                }
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    protected Configuration getConfiguration() {
        return configuration;
    }

    public String validate() throws ConfigException {
        StringBuffer configuration = new StringBuffer();
        try {
            configuration.append("Governance configuration:").append("\n");
            configuration.append("governance.bpm.url: " + this.getBpmUrl()).append("\n");
            configuration.append("governance.bpm.user: " + this.getBpmUser()).append("\n");
            configuration.append("governance.bpm.password: " + this.getBpmPassword().replaceAll(".", "*")).append("\n");
            configuration.append("sramp.repo.url: " + this.getSrampUrl()).append("\n");
            configuration.append("sramp.repo.user: " + this.getSrampUser()).append("\n");
            configuration.append("sramp.repo.password: " + this.getSrampPassword()).append("\n");
            configuration.append("sramp.repo.validating: " + this.getSrampValidating()).append("\n");
            configuration.append("sramp.repo.auth.provider: " + this.getSrampAuthProvider()).append("\n");
            configuration.append("sramp.repo.auth.saml.issuer: " + this.getSrampAuthProvider()).append("\n");
            configuration.append("sramp.repo.auth.saml.service: " + this.getSrampAuthProvider()).append("\n");
            int i = 1;
            for (Query query : this.getQueries()) {
                configuration.append("Query ").append(i++).append("\n");
                configuration.append(query.toString()).append("\n\n");
            }
            i = 1;
            for (String name : this.getTargets().keySet()) {
                configuration.append("Target ").append(i++).append("\n");
                configuration.append(this.getTargets().get(name).toString()).append("\n\n");
            }
            this.log.debug(configuration.toString());
            return configuration.toString();
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (MalformedURLException e) {
            throw new ConfigException(e);
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
    }

    public String getBpmUser() {
        return this.getConfiguration().getString("governance.bpm.user", DEFAULT_GOVERNANCE_USER);
    }

    public String getBpmPassword() {
        return this.getConfiguration().getString("governance.bpm.password", DEFAULT_GOVERNANCE_PASSWORD);
    }

    public String getOverlordUser() {
        return this.getConfiguration().getString("governance.user", DEFAULT_GOVERNANCE_USER);
    }

    public String getOverlordPassword() {
        return this.getConfiguration().getString("governance.password", DEFAULT_GOVERNANCE_PASSWORD);
    }

    public String getRhqUser() {
        return this.getConfiguration().getString("rhq.rest.user", DEFAULT_RHQ_USER);
    }

    public String getRhqPassword() {
        return this.getConfiguration().getString("rhq.rest.password", DEFAULT_GOVERNANCE_PASSWORD);
    }

    public URL getBpmUrl() throws MalformedURLException {
        return new URL(this.getConfiguration().getString("governance.bpm.url", "http://localhost:8080/gwt-console-server"));
    }

    public URL getSrampUrl() throws MalformedURLException {
        return new URL(this.getConfiguration().getString("sramp.repo.url", "http://localhost:8080/s-ramp-server"));
    }

    public String getSrampUser() {
        return this.getConfiguration().getString("sramp.repo.user", "admin");
    }

    public String getSrampPassword() {
        return this.getConfiguration().getString("sramp.repo.password", "overlord");
    }

    public Class<?> getSrampAuthProvider() throws Exception {
        String authProviderClassName = this.getConfiguration().getString("sramp.repo.auth.provider", BasicAuthenticationProvider.class.getName());
        if (authProviderClassName == null) {
            return null;
        }
        return Class.forName(authProviderClassName);
    }

    public boolean getSrampValidating() throws Exception {
        return "true".equals(this.getConfiguration().getString("sramp.repo.validating", "false"));
    }

    public String getSrampSamlIssuer() {
        return this.getConfiguration().getString("sramp.repo.auth.saml.issuer", "/dtgov");
    }

    public String getSrampSamlService() {
        return this.getConfiguration().getString("sramp.repo.auth.saml.service", "/s-ramp-server");
    }

    public String getGovernanceUrl() {
        return this.getConfiguration().getString("governance.url", "http://localhost:8080/dtgov");
    }

    public String getDTGovUiUrl() {
        return this.getConfiguration().getString("dtgov.ui.url", "http://localhost:8080/dtgov-ui");
    }

    public Map<String, Target> getTargets() throws ConfigException {
        HashMap<String, Target> targets = new HashMap<String, Target>();
        String[] targetStrings = this.getConfiguration().getStringArray("governance.targets");
        StringBuffer errors = new StringBuffer(TARGET_ERROR);
        boolean hasErrors = false;
        for (String targetString : targetStrings) {
            Target target;
            String[] info = targetString.split("\\|");
            if (info.length != 4) {
                hasErrors = true;
                errors.append(targetString).append("\n");
            }
            if (hasErrors) continue;
            String name = info[0];
            String classifier = info[1];
            String type = info[2];
            if (Target.TYPE.COPY.toString().equalsIgnoreCase(type)) {
                Target target2 = new Target(name, classifier, info[3]);
                targets.put(target2.getName(), target2);
                continue;
            }
            if (Target.TYPE.RHQ.toString().equalsIgnoreCase(type)) {
                String rhqConfigStr = info[3].replaceAll("\\{rhq.user\\}", DEFAULT_RHQ_USER).replaceAll("\\{rhq.password\\}", DEFAULT_RHQ_PASSWORD).replaceAll("\\{rhq.baseUrl\\}", DEFAULT_RHQ_BASEURL);
                String[] rhqConfig = rhqConfigStr.split("\\:\\:");
                Target target3 = new Target(name, classifier, rhqConfig[0], rhqConfig[1], rhqConfig[2]);
                targets.put(target3.getName(), target3);
                continue;
            }
            if (Target.TYPE.AS_CLI.toString().equalsIgnoreCase(type)) {
                String[] cliConfig = info[3].split("\\:\\:");
                target = new Target(name, classifier, cliConfig[0], cliConfig[1], cliConfig[2], Integer.valueOf(cliConfig[3]));
                targets.put(target.getName(), target);
                continue;
            }
            if (!Target.TYPE.MAVEN.toString().equalsIgnoreCase(type)) continue;
            String[] mvnConfig = info[3].split("\\:\\:");
            target = new Target(name, classifier, mvnConfig[0], Boolean.parseBoolean(mvnConfig[1]), Boolean.parseBoolean(mvnConfig[2]));
            targets.put(target.getName(), target);
        }
        if (hasErrors) {
            throw new ConfigException(errors.toString());
        }
        return targets;
    }

    public Set<Query> getQueries() throws ConfigException {
        HashSet<Query> queries = new HashSet<Query>();
        String[] queryStrings = this.getConfiguration().getStringArray("governance.queries");
        StringBuffer errors = new StringBuffer(QUERY_ERROR);
        boolean hasErrors = false;
        for (String queryString : queryStrings) {
            String[] info = queryString.split("\\|");
            if (info.length != 3) {
                hasErrors = true;
                errors.append(queryString).append("\n");
            }
            if (hasErrors) continue;
            String params = info[2];
            params = params.replaceAll("\\{governance.url\\}", this.getGovernanceUrl());
            params = params.replaceAll("\\{dtgov.ui.url\\}", this.getDTGovUiUrl());
            Query query = new Query(info[0], info[1], params);
            queries.add(query);
        }
        if (hasErrors) {
            throw new ConfigException(errors.toString());
        }
        return queries;
    }

    public Map<String, NotificationDestinations> getNotificationDestinations(String channel) throws ConfigException {
        HashMap<String, NotificationDestinations> destinationMap = new HashMap<String, NotificationDestinations>();
        String[] destinationStrings = this.getConfiguration().getStringArray("governance." + channel);
        StringBuffer errors = new StringBuffer(NOTIFICATION_ERROR);
        boolean hasErrors = false;
        for (String destinationString : destinationStrings) {
            String[] info = destinationString.split("\\|");
            if (info.length != 3) {
                hasErrors = true;
                errors.append(destinationString).append("\n");
            }
            if (hasErrors) continue;
            NotificationDestinations destination = new NotificationDestinations(info[0], info[1], info[2]);
            destinationMap.put(destination.getName(), destination);
        }
        if (hasErrors) {
            throw new ConfigException(errors.toString());
        }
        return destinationMap;
    }

    public long getQueryInterval() {
        return this.getConfiguration().getLong("governance.query.interval", 300000L);
    }

    public String getJNDIEmailName() {
        return this.getConfiguration().getString("governance.jndi.email.reference", DEFAULT_JNDI_EMAIL_REF);
    }

    public String getDefaultEmailDomain() {
        return this.getConfiguration().getString("governance.email.domain", DEFAULT_EMAIL_DOMAIN);
    }

    public String getDefaultEmailFromAddress() {
        return this.getConfiguration().getString("governance.email.from", DEFAULT_EMAIL_FROM);
    }

    public String getSrampWagonVersion() {
        return Release.getVersionFromManifest("s-ramp-wagon");
    }

    public Boolean getSrampWagonSnapshots() {
        return this.getConfiguration().getBoolean("dtgov.s-ramp-wagon.snapshots", true);
    }

    public Boolean getSrampWagonReleases() {
        return this.getConfiguration().getBoolean("dtgov.s-ramp-wagon.releases", true);
    }

    public String getGovernanceWorkflowGroup() {
        return this.getConfiguration().getString("dtgov.workflows.group", DEFAULT_GOVERNANCE_WORKFLOW_GROUP);
    }

    public String getGovernanceWorkflowName() {
        return this.getConfiguration().getString("dtgov.workflows.name", DEFAULT_GOVERNANCE_WORKFLOW_NAME);
    }

    public String getGovernanceWorkflowVersion() {
        String defaultDtGovVersion = Release.getGovernanceVersion();
        if (defaultDtGovVersion == null || defaultDtGovVersion.equals("unknown")) {
            defaultDtGovVersion = DEFAULT_GOVERNANCE_WORKFLOW_VERSION;
        }
        return this.getConfiguration().getString("dtgov.workflows.version", defaultDtGovVersion);
    }

    public String getGovernanceWorkflowPackage() {
        return this.getConfiguration().getString("dtgov.workflows.package", DEFAULT_GOVERNANCE_WORKFLOW_PACKAGE);
    }

    static {
        configuration.addConfiguration((Configuration)new SystemConfiguration());
        String configFile = configuration.getString("governance.file.name");
        Long refreshDelay = configuration.getLong("governance.file.refresh", 30000L);
        URL url = Governance.findDtgovConfig(configFile);
        try {
            if (url != null) {
                PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(url);
                FileChangedReloadingStrategy fileChangedReloadingStrategy = new FileChangedReloadingStrategy();
                fileChangedReloadingStrategy.setRefreshDelay(refreshDelay.longValue());
                propertiesConfiguration.setReloadingStrategy((ReloadingStrategy)fileChangedReloadingStrategy);
                configuration.addConfiguration((Configuration)propertiesConfiguration);
            }
            configuration.addConfiguration((Configuration)new PropertiesConfiguration(Governance.class.getClassLoader().getResource("governance.config.txt")));
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

