/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance.shell.commands;

import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientRequestFactory;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.api.Arguments;
import org.overlord.sramp.shell.api.ShellContext;
import org.overlord.sramp.shell.api.SimpleShellContext;

public class Dir2BrmsCommand
extends AbstractShellCommand {
    ClientRequestFactory fac = null;

    public static void main(String[] args) throws Exception {
        String brmsPackageName = "SRAMPPackage";
        String baseUrl = "http://localhost:8080/drools-guvnor";
        String brmsUserId = "admin";
        String brmsPassword = "admin";
        String packagePath = null;
        if (args.length > 0) {
            brmsPackageName = args[0];
        }
        if (args.length > 1) {
            baseUrl = args[1];
        }
        if (args.length > 2) {
            brmsUserId = args[2];
        }
        if (args.length > 3) {
            brmsPassword = args[3];
        }
        if (args.length > 4) {
            packagePath = args[4];
        }
        StringBuilder argLine = new StringBuilder();
        argLine.append(brmsPackageName).append(" ").append(baseUrl).append(" ").append(brmsUserId).append(" ").append(brmsPassword);
        if (packagePath != null) {
            argLine.append(" ").append(packagePath);
        }
        Dir2BrmsCommand cmd = new Dir2BrmsCommand();
        SimpleShellContext context = new SimpleShellContext();
        cmd.setArguments(new Arguments(argLine.toString()));
        cmd.setContext((ShellContext)context);
        cmd.execute();
    }

    public void printUsage() {
        this.print("brms:dir2brms <brmsPackageName> <brmsBaseUrl> <brmsUserId> <brmsPassword> <packagePath>", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'dir2brms' command copies the default set of governance", new Object[0]);
        this.print("workflow artifacts into your BRMS system.  This should really", new Object[0]);
        this.print("only be done when you first install BRMS for use with S-RAMP.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usage:", new Object[0]);
        this.print("> brms:dir2brms SRAMPPackage http://localhost:8080/drools-guvnor admin admin /home/user/s-ramp-workflows.jar", new Object[0]);
    }

    public void execute() throws Exception {
        try {
            String brmsPackageName = this.optionalArgument(0, "SRAMPPackage");
            String brmsBaseUrl = this.optionalArgument(1, "http://localhost:8080/drools-guvnor");
            String brmsUserId = this.optionalArgument(2, "admin");
            String brmsPassword = this.optionalArgument(3, "admin");
            String packagePath = this.optionalArgument(4);
            this.print("Copying default governance package to BRMS using: ", new Object[0]);
            this.print("   brmsPackageName..: %1$s", new Object[]{brmsPackageName});
            this.print("   brmsBaseUrl......: %1$s", new Object[]{brmsBaseUrl});
            this.print("   brmsUserId.......: %1$s", new Object[]{brmsUserId});
            this.print("   brmsPassword.....: %1$s", new Object[]{brmsPassword});
            this.print("   packagePath......: %1$s", new Object[]{packagePath});
            String brmsURLStr = brmsBaseUrl + "/rest/packages/";
            boolean brmsExists = this.urlExists(brmsURLStr, brmsUserId, brmsPassword);
            if (!brmsExists) {
                this.print("Can't find BRMS endpoint: " + brmsURLStr, new Object[0]);
                return;
            }
            if (!this.urlExists(brmsURLStr + brmsPackageName, brmsUserId, brmsPassword)) {
                this.createNewPackage(brmsBaseUrl, brmsPackageName, brmsUserId, brmsPassword);
            }
            this.addAssetsToPackageToBRMS(brmsBaseUrl, brmsPackageName, brmsUserId, brmsPassword, packagePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.print("**********************************************************************", new Object[0]);
    }

    public boolean urlExists(String checkUrl, String user, String password) {
        try {
            URL checkURL = new URL(checkUrl);
            HttpURLConnection checkConnection = (HttpURLConnection)checkURL.openConnection();
            checkConnection.setRequestMethod("GET");
            checkConnection.setRequestProperty("Accept", "application/xml");
            checkConnection.setConnectTimeout(10000);
            checkConnection.setReadTimeout(10000);
            this.applyAuth(checkConnection, user, password);
            checkConnection.connect();
            return checkConnection.getResponseCode() == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void applyAuth(HttpURLConnection connection, String user, String password) {
        String auth = user + ":" + password;
        connection.setRequestProperty("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])auth.getBytes())));
    }

    public void createNewPackage(String brmsBaseUrl, String pkgName, String userId, String password) throws Exception {
        String urlStr = brmsBaseUrl + "/rest/packages";
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userId, password);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)credentials);
        ApacheHttpClient4Executor clientExecutor = new ApacheHttpClient4Executor((HttpClient)httpClient);
        this.fac = new ClientRequestFactory((ClientExecutor)clientExecutor, new URI(brmsBaseUrl));
        ClientRequest createNewPackageRequest = this.fac.createRequest(urlStr);
        createNewPackageRequest.accept("application/atom+xml");
        Entry entry = new Entry();
        entry.setTitle(pkgName);
        entry.setSummary("S-RAMP Package containing Governance Workflows");
        createNewPackageRequest.body("application/atom+xml", (Object)entry);
        ClientResponse newPackageResponse = createNewPackageRequest.post(Entry.class);
        this.print("response status=" + newPackageResponse.getResponseStatus(), new Object[0]);
        this.print("Create new package with id=" + ((Entry)newPackageResponse.getEntity()).getId(), new Object[0]);
    }

    public void addAssetsToPackageToBRMS(String brmsBaseUrl, String pkgName, String userId, String password, String packagePath) throws Exception {
        String urlStr = brmsBaseUrl + "/rest/packages/" + pkgName + "/assets";
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userId, password);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)credentials);
        ApacheHttpClient4Executor clientExecutor = new ApacheHttpClient4Executor((HttpClient)httpClient);
        this.fac = new ClientRequestFactory((ClientExecutor)clientExecutor, new URI(urlStr));
        if (packagePath != null) {
            File packageJar = new File(packagePath);
            if (!packageJar.isFile()) {
                throw new Exception("Included path to workflows package (JAR) is invalid: " + packagePath);
            }
            this.addAssetsToPackageToBRMSFromJar(brmsBaseUrl, pkgName, userId, password, packageJar);
        } else {
            this.addAssetsToPackageToBRMSFromClasspath(brmsBaseUrl, pkgName, userId, password);
        }
        String urlCompile = brmsBaseUrl + "/rest/packages/" + pkgName + "/binary";
        ClientRequest compileRequest = this.fac.createRequest(urlCompile);
        ClientResponse compileResponse = compileRequest.get(InputStream.class);
        if (compileResponse.getStatus() == 200) {
            this.print("Upload complete", new Object[0]);
        } else {
            System.err.println(compileResponse.getStatus() + " " + compileResponse.getResponseStatus().getReasonPhrase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAssetsToPackageToBRMSFromJar(String brmsBaseUrl, String pkgName, String userId, String password, File packageJar) throws Exception {
        String urlStr = brmsBaseUrl + "/rest/packages/" + pkgName + "/assets";
        HashSet<String> exclusions = new HashSet<String>();
        exclusions.add(".gitignore");
        exclusions.add(".cvsignore");
        JarFile jarFile = null;
        String assetPrefix = "governance-workflows/" + pkgName;
        try {
            jarFile = new JarFile(packageJar);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String assetName;
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.startsWith(assetPrefix) || entry.isDirectory() || exclusions.contains(assetName = new File(entryName).getName())) continue;
                this.print("Processing workflow asset: " + entryName, new Object[0]);
                ClientRequest addAssetRequest = this.fac.createRequest(urlStr);
                InputStream is = null;
                try {
                    is = jarFile.getInputStream(entry);
                    this.print("Uploading " + entryName + " -> " + urlStr, new Object[0]);
                    this.uploadToBrms(assetName, is, addAssetRequest);
                }
                finally {
                    is.close();
                }
            }
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }

    private void addAssetsToPackageToBRMSFromClasspath(String brmsBaseUrl, String pkgName, String userId, String password) throws Exception {
        block4: {
            String path;
            String dir;
            String urlStr;
            block3: {
                File[] fileList;
                urlStr = brmsBaseUrl + "/rest/packages/" + pkgName + "/assets";
                dir = "/governance-workflows/" + pkgName;
                URL url = ((Object)((Object)this)).getClass().getResource(dir);
                if (url == null) {
                    throw new Exception("Could not find " + dir + " on the classpath");
                }
                path = url.toURI().getSchemeSpecificPart();
                File srampPackageDir = new File(path);
                if (!srampPackageDir.exists()) break block3;
                FilenameFilter droolsFiles = new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String name) {
                        return !name.startsWith(".");
                    }
                };
                for (File file : fileList = srampPackageDir.listFiles(droolsFiles)) {
                    ClientRequest addAssetRequest = this.fac.createRequest(urlStr);
                    InputStream is = file.toURI().toURL().openStream();
                    this.print("uploading " + file.getName() + " -> " + urlStr, new Object[0]);
                    this.uploadToBrms(file.getName(), is, addAssetRequest);
                }
                break block4;
            }
            if (path.indexOf("!") <= 0) break block4;
            String[] paths = path.split("!");
            Enumeration<JarEntry> en = new JarFile(new File(new URI(paths[0]))).entries();
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || name.contains("/.") || !name.startsWith(dir.substring(1))) continue;
                String fileName = name.substring(name.lastIndexOf("/") + 1, name.length());
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/" + name);
                ClientRequest addAssetRequest = this.fac.createRequest(urlStr);
                this.print("uploading " + name, new Object[0]);
                this.uploadToBrms(fileName, is, addAssetRequest);
            }
        }
    }

    private void uploadToBrms(String fileName, InputStream is, ClientRequest addAssetRequest) throws Exception {
        addAssetRequest.body("application/octet-stream", (Object)is);
        addAssetRequest.accept("application/atom+xml");
        addAssetRequest.header("Slug", (Object)fileName);
        ClientResponse uploadAssetResponse = addAssetRequest.post(String.class);
        int status = uploadAssetResponse.getStatus();
        String response = (String)uploadAssetResponse.getEntity();
        if (200 != status) {
            System.err.println("Upload to BRMS failed with response status = " + status);
        }
    }
}

