/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance;

import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.overlord.sramp.governance.ConfigException;
import org.overlord.sramp.governance.Governance;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ConfigurationTest {
    @Test
    public void testAConfigure() throws ConfigException {
        Governance governance = new Governance();
        Map targets = governance.getTargets();
        Assert.assertTrue((targets.size() > 0 ? 1 : 0) != 0);
        Set queries = governance.getQueries();
        Assert.assertTrue((queries.size() > 0 ? 1 : 0) != 0);
        System.out.println(governance.validate());
    }

    @Test
    public void testBad2QueryConfiguration() throws ConfigException {
        Governance governance = new Governance(){

            protected Configuration getConfiguration() {
                try {
                    return new PropertiesConfiguration(ConfigurationTest.class.getClassLoader().getResource("bad2-governance.config.txt"));
                }
                catch (ConfigurationException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        try {
            governance.validate();
            Assert.fail((String)"Expecting exception");
        }
        catch (ConfigException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith(Governance.QUERY_ERROR));
        }
    }

    @Test
    public void testBad3TargetConfiguration() throws ConfigException {
        Governance governance = new Governance(){

            protected Configuration getConfiguration() {
                try {
                    return new PropertiesConfiguration(ConfigurationTest.class.getClassLoader().getResource("bad3-governance.config.txt"));
                }
                catch (ConfigurationException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        try {
            governance.validate();
            Assert.fail((String)"Expecting exception");
        }
        catch (ConfigException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith(Governance.TARGET_ERROR));
        }
    }
}

