/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.jbpm.util;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.overlord.sramp.governance.Governance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientWorkItemHandler
implements WorkItemHandler {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        try {
            Integer readTimeout;
            String urlStr = (String)workItem.getParameter("Url");
            String method = (String)workItem.getParameter("Method");
            if (urlStr == null || method == null) {
                throw new Exception("Url and Method are required parameters");
            }
            urlStr = urlStr.toLowerCase();
            Map params = workItem.getParameters();
            Integer connectTimeout = (Integer)params.get("ConnectTimeout");
            if (connectTimeout == null) {
                connectTimeout = 60000;
            }
            if ((readTimeout = (Integer)params.get("ReadTimeout")) == null) {
                readTimeout = 60000;
            }
            for (String key : params.keySet()) {
                if (!urlStr.contains("{")) break;
                String variable = "{" + key.toLowerCase() + "}";
                if (!urlStr.contains(variable)) continue;
                String escapedVariable = "\\{" + key.toLowerCase() + "\\}";
                String urlEncodedParam = URLEncoder.encode((String)params.get(key), "UTF-8").replaceAll("%2F", "*2F");
                urlStr = urlStr.replaceAll(escapedVariable, urlEncodedParam);
            }
            if (urlStr.contains("{")) {
                throw new Exception("Url contains more tokens, please check the workflow and pass in the correct parameters. Url=" + urlStr);
            }
            this.log.info("Calling " + method + " TO: " + urlStr);
            URL url = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(method);
            connection.setConnectTimeout(connectTimeout);
            connection.setReadTimeout(readTimeout);
            this.addAuthorization(connection);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                InputStream is = (InputStream)connection.getContent();
                String reply = IOUtils.toString((InputStream)is);
                this.log.info("reply=" + reply);
            } else {
                workItem.getParameters().put("Status", "ERROR " + responseCode);
                workItem.getParameters().put("StatusMsg", "endpoint " + urlStr + " could not be reached");
                this.log.error("endpoint could not be reached");
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        manager.completeWorkItem(workItem.getId(), null);
    }

    private void addAuthorization(HttpURLConnection connection) {
        Governance governance = new Governance();
        String username = governance.getOverlordUser();
        String password = governance.getOverlordPassword();
        if (username != null && password != null) {
            String b64Auth = Base64.encodeBase64String((byte[])(username + ":" + password).getBytes()).trim();
            connection.setRequestProperty("Authorization", "Basic " + b64Auth);
        } else {
            this.log.warn("No username (guvnor.usr) and/or password (guvnor.pwd) found in the jbpm console properties file.");
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }
}

