/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.jbpm.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.overlord.sramp.governance.Governance;
import org.overlord.sramp.wagon.SrampWagon;

public class SrampWagonProxy
implements Wagon {
    private static final String MAVEN_META_DATA = "\r\n<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<metadata modelVersion=\"1.1.0\">\r\n  <groupId>GROUP_ID</groupId>\r\n  <artifactId>ARTIFACT_ID</artifactId>\r\n  <version>VERSION</version>\r\n  <versioning>\r\n    <snapshot>\r\n      <timestamp>LAST_MODIFIED_TIME</timestamp>\r\n      <buildNumber>1</buildNumber>\r\n    </snapshot>\r\n    <lastUpdated>20130718220725</lastUpdated>\r\n    <snapshotVersions>\r\n      <snapshotVersion>\r\n        <extension>jar</extension>\r\n        <value>VERSION-1</value>\r\n        <updated>LAST_MODIFIED_TIME</updated>\r\n      </snapshotVersion>\r\n    </snapshotVersions>\r\n  </versioning>\r\n</metadata>\r\n";
    private SrampWagon delegate;
    private Date wagonDate = new Date();

    public SrampWagonProxy() {
        this.delegate = new SrampWagon();
        this.injectLoggerInto(this.delegate);
    }

    private void injectLoggerInto(SrampWagon wagon) {
        ConsoleLogger logger = new ConsoleLogger();
        try {
            Field field = SrampWagon.class.getDeclaredField("logger");
            field.setAccessible(true);
            field.set(wagon, logger);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (resourceName.endsWith("maven-metadata.xml")) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(destination);
                String xml = this.generateMavenMetaData();
                StringReader in = new StringReader(xml);
                IOUtils.copy((Reader)in, (OutputStream)out);
            }
            catch (Exception e) {
                try {
                    throw new TransferFailedException(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)out);
            return;
        }
        this.delegate.get(resourceName, destination);
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (resourceName.endsWith("maven-metadata.xml")) {
            boolean bl;
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(destination);
                String xml = this.generateMavenMetaData();
                StringReader in = new StringReader(xml);
                IOUtils.copy((Reader)in, (OutputStream)out);
                bl = true;
            }
            catch (Exception e) {
                try {
                    throw new TransferFailedException(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)out);
            return bl;
        }
        return this.delegate.getIfNewer(resourceName, destination, timestamp);
    }

    public void put(File source, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.delegate.put(source, destination);
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.delegate.putDirectory(sourceDirectory, destinationDirectory);
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        return true;
    }

    public List<String> getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        return this.delegate.getFileList(destinationDirectory);
    }

    public boolean supportsDirectoryCopy() {
        return this.delegate.supportsDirectoryCopy();
    }

    public Repository getRepository() {
        return this.delegate.getRepository();
    }

    public void connect(Repository source) throws ConnectionException, AuthenticationException {
        this.delegate.connect(source);
    }

    public void connect(Repository source, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        this.delegate.connect(source, proxyInfo);
    }

    public void connect(Repository source, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        this.delegate.connect(source, proxyInfoProvider);
    }

    public void connect(Repository source, AuthenticationInfo authenticationInfo) throws ConnectionException, AuthenticationException {
        this.delegate.connect(source, authenticationInfo);
    }

    public void connect(Repository source, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        this.delegate.connect(source, authenticationInfo, proxyInfo);
    }

    public void connect(Repository source, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        this.delegate.connect(source, authenticationInfo, proxyInfoProvider);
    }

    public void openConnection() throws ConnectionException, AuthenticationException {
        this.delegate.openConnection();
    }

    public void disconnect() throws ConnectionException {
        this.delegate.disconnect();
    }

    public void setTimeout(int timeoutValue) {
        this.delegate.setTimeout(timeoutValue);
    }

    public int getTimeout() {
        return this.delegate.getTimeout();
    }

    public void setReadTimeout(int timeoutValue) {
        this.delegate.setReadTimeout(timeoutValue);
    }

    public int getReadTimeout() {
        return this.delegate.getReadTimeout();
    }

    public void addSessionListener(SessionListener listener) {
        this.delegate.addSessionListener(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.delegate.removeSessionListener(listener);
    }

    public boolean hasSessionListener(SessionListener listener) {
        return this.delegate.hasSessionListener(listener);
    }

    public void addTransferListener(TransferListener listener) {
        this.delegate.addTransferListener(listener);
    }

    public void removeTransferListener(TransferListener listener) {
        this.delegate.removeTransferListener(listener);
    }

    public boolean hasTransferListener(TransferListener listener) {
        return this.delegate.hasTransferListener(listener);
    }

    public boolean isInteractive() {
        return this.delegate.isInteractive();
    }

    public void setInteractive(boolean interactive) {
        this.delegate.setInteractive(interactive);
    }

    protected String generateMavenMetaData() {
        Governance governance = new Governance();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd.hhmmss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        String tstamp = df.format(this.wagonDate);
        return MAVEN_META_DATA.replace("VERSION", governance.getGovernanceWorkflowVersion()).replace("ARTIFACT_ID", governance.getGovernanceWorkflowName()).replace("GROUP_ID", governance.getGovernanceWorkflowGroup()).replace("LAST_MODIFIED_TIME", tstamp);
    }
}

