/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.taskapi;

import java.security.Principal;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import javax.persistence.OptimisticLockException;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.TaskSummary;
import org.kie.api.task.model.User;
import org.overlord.dtgov.jbpm.ejb.ProcessOperationException;
import org.overlord.dtgov.taskapi.TaskSummaryComparator;
import org.overlord.dtgov.taskapi.types.FindTasksRequest;
import org.overlord.dtgov.taskapi.types.FindTasksResponse;
import org.overlord.dtgov.taskapi.types.StatusType;
import org.overlord.dtgov.taskapi.types.TaskDataType;
import org.overlord.dtgov.taskapi.types.TaskSummaryType;
import org.overlord.dtgov.taskapi.types.TaskType;

@Stateless
@TransactionManagement(value=TransactionManagementType.BEAN)
@Path(value="/tasks")
public class TaskApi {
    @Inject
    TaskService taskService;
    @Resource
    private UserTransaction ut;

    @GET
    @Path(value="list")
    @Produces(value={"application/xml"})
    public FindTasksResponse listTasks(@Context HttpServletRequest httpRequest, @QueryParam(value="startIndex") Integer startIndex, @QueryParam(value="endIndex") Integer endIndex, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="orderAscending") Boolean orderAscending, @QueryParam(value="status") String status, @QueryParam(value="priority") Integer priority) throws Exception {
        FindTasksRequest findTasksReq = new FindTasksRequest();
        findTasksReq.setStartIndex(Integer.valueOf(0));
        if (startIndex != null) {
            findTasksReq.setStartIndex(startIndex);
        }
        findTasksReq.setEndIndex(Integer.valueOf(19));
        if (endIndex != null) {
            findTasksReq.setEndIndex(endIndex);
        }
        findTasksReq.setOrderBy("priority");
        if (orderBy != null) {
            findTasksReq.setOrderBy(orderBy);
        }
        findTasksReq.setOrderAscending(Boolean.valueOf(false));
        if (orderAscending != null) {
            findTasksReq.setOrderAscending(orderAscending);
        }
        findTasksReq.getPriority().clear();
        if (priority != null) {
            findTasksReq.getPriority().add(priority);
        }
        findTasksReq.getStatus().clear();
        if (status != null) {
            findTasksReq.getStatus().add(StatusType.fromValue((String)status));
        }
        return this.findTasks(findTasksReq, httpRequest);
    }

    @POST
    @Path(value="find")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public FindTasksResponse findTasks(FindTasksRequest findTasksRequest, @Context HttpServletRequest httpRequest) throws Exception {
        String currentUser = this.assertCurrentUser(httpRequest);
        FindTasksResponse response = new FindTasksResponse();
        List list = this.taskService.getTasksAssignedAsPotentialOwner(currentUser, "en-UK");
        list.addAll(this.taskService.getTasksOwned(currentUser, "en-UK"));
        String orderBy = findTasksRequest.getOrderBy() == null ? "priority" : findTasksRequest.getOrderBy();
        boolean ascending = findTasksRequest.isOrderAscending();
        TreeSet<TaskSummary> sortedFiltered = new TreeSet<TaskSummary>((Comparator<TaskSummary>)new TaskSummaryComparator(orderBy, ascending));
        for (TaskSummary task : list) {
            if (!this.accepts(task, findTasksRequest)) continue;
            sortedFiltered.add(task);
        }
        int startIdx = findTasksRequest.getStartIndex();
        int endIdx = findTasksRequest.getEndIndex();
        int idx = 0;
        for (TaskSummary task : sortedFiltered) {
            if (idx >= startIdx && idx <= endIdx) {
                TaskSummaryType taskSummary = new TaskSummaryType();
                taskSummary.setId(String.valueOf(task.getId()));
                taskSummary.setName(task.getName());
                User actualOwner = task.getActualOwner();
                if (actualOwner != null) {
                    taskSummary.setOwner(actualOwner.getId());
                }
                taskSummary.setPriority(task.getPriority());
                taskSummary.setStatus(StatusType.fromValue((String)task.getStatus().toString()));
                response.getTaskSummary().add(taskSummary);
            }
            ++idx;
        }
        response.setTotalResults((long)response.getTaskSummary().size());
        return response;
    }

    @GET
    @Path(value="get/{taskId}")
    @Produces(value={"application/xml"})
    public TaskType getTask(@Context HttpServletRequest httpRequest, @PathParam(value="taskId") long taskId) throws Exception {
        List names;
        this.assertCurrentUser(httpRequest);
        Task task = this.taskService.getTaskById(taskId);
        long docId = this.taskService.getTaskById(taskId).getTaskData().getDocumentContentId();
        Content content = this.taskService.getContentById(docId);
        Map inputParams = (Map)ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        TaskType rval = new TaskType();
        List descriptions = task.getDescriptions();
        if (descriptions != null && !descriptions.isEmpty()) {
            rval.setDescription(((I18NText)descriptions.iterator().next()).getText());
        }
        if ((names = task.getNames()) != null && !names.isEmpty()) {
            rval.setName(((I18NText)names.iterator().next()).getText());
        }
        rval.setPriority(task.getPriority());
        rval.setId(String.valueOf(task.getId()));
        rval.setType(task.getTaskType());
        TaskData taskData = task.getTaskData();
        if (taskData != null) {
            Date expTime;
            User owner = taskData.getActualOwner();
            if (owner != null) {
                rval.setOwner(owner.getId());
            }
            if ((expTime = taskData.getExpirationTime()) != null) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(expTime);
                DatatypeFactory dtFactory = DatatypeFactory.newInstance();
                rval.setDueDate(dtFactory.newXMLGregorianCalendar(cal));
            }
            rval.setStatus(StatusType.fromValue((String)taskData.getStatus().toString()));
        }
        if (inputParams != null && inputParams.size() > 0) {
            if (rval.getTaskData() == null) {
                rval.setTaskData(new TaskDataType());
            }
            for (String key : inputParams.keySet()) {
                TaskDataType.Entry entry = new TaskDataType.Entry();
                entry.setKey(key);
                entry.setValue(String.valueOf(inputParams.get(key)));
                rval.getTaskData().getEntry().add(entry);
            }
        }
        return rval;
    }

    @GET
    @Path(value="claim/{taskId}")
    @Produces(value={"application/xml"})
    public TaskType claimTask(@Context HttpServletRequest httpRequest, @PathParam(value="taskId") long taskId) throws Exception {
        String currentUser = this.assertCurrentUser(httpRequest);
        this.ut.begin();
        try {
            this.taskService.claim(taskId, currentUser);
            this.ut.commit();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.getTask(httpRequest, taskId);
    }

    @GET
    @Path(value="release/{taskId}")
    @Produces(value={"application/xml"})
    public TaskType releaseTask(@Context HttpServletRequest httpRequest, @PathParam(value="taskId") long taskId) throws Exception {
        String currentUser = this.assertCurrentUser(httpRequest);
        this.ut.begin();
        try {
            this.taskService.release(taskId, currentUser);
            this.ut.commit();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.getTask(httpRequest, taskId);
    }

    @GET
    @Path(value="start/{taskId}")
    @Produces(value={"application/xml"})
    public TaskType startTask(@Context HttpServletRequest httpRequest, @PathParam(value="taskId") long taskId) throws Exception {
        String currentUser = this.assertCurrentUser(httpRequest);
        this.ut.begin();
        try {
            this.taskService.start(taskId, currentUser);
            this.ut.commit();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.getTask(httpRequest, taskId);
    }

    @GET
    @Path(value="stop/{taskId}")
    @Produces(value={"application/xml"})
    public TaskType stopTask(@Context HttpServletRequest httpRequest, @PathParam(value="taskId") long taskId) throws Exception {
        String currentUser = this.assertCurrentUser(httpRequest);
        this.ut.begin();
        try {
            this.taskService.stop(taskId, currentUser);
            this.ut.commit();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.getTask(httpRequest, taskId);
    }

    @POST
    @Path(value="complete/{taskId}")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public TaskType completeTask(TaskDataType taskData, @Context HttpServletRequest httpRequest, @PathParam(value="taskId") long taskId) throws Exception {
        String currentUser = this.assertCurrentUser(httpRequest);
        this.ut.begin();
        try {
            Map data = this.taskDataAsMap(taskData);
            this.taskService.complete(taskId, currentUser, data);
            this.ut.commit();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.getTask(httpRequest, taskId);
    }

    @POST
    @Path(value="fail/{taskId}")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    public TaskType failTask(TaskDataType taskData, @Context HttpServletRequest httpRequest, @PathParam(value="taskId") long taskId) throws Exception {
        String currentUser = this.assertCurrentUser(httpRequest);
        this.ut.begin();
        try {
            Map data = this.taskDataAsMap(taskData);
            this.taskService.fail(taskId, currentUser, data);
            this.ut.commit();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.getTask(httpRequest, taskId);
    }

    private Map<String, Object> taskDataAsMap(TaskDataType taskData) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (TaskDataType.Entry entry : taskData.getEntry()) {
            data.put(entry.getKey(), entry.getValue());
        }
        return data;
    }

    protected void handleException(Exception error) throws Exception {
        if (error instanceof RollbackException) {
            Throwable cause = error.getCause();
            if (cause != null && cause instanceof OptimisticLockException) {
                throw new ProcessOperationException("The same task instance has likely been accessed concurrently", (Throwable)error);
            }
            throw error;
        }
        if (error instanceof PermissionDeniedException) {
            if (this.ut.getStatus() == 0) {
                this.ut.rollback();
            }
            throw new ProcessOperationException("The task has likely been claimed/started by another user.", (Throwable)error);
        }
        if (this.ut.getStatus() == 0) {
            this.ut.rollback();
        }
        throw error;
    }

    protected String assertCurrentUser(HttpServletRequest httpRequest) throws Exception {
        Principal principal = httpRequest.getUserPrincipal();
        if (principal == null) {
            throw new Exception("User not authenticated.");
        }
        return principal.getName();
    }

    private boolean accepts(TaskSummary task, FindTasksRequest findTasksRequest) {
        XMLGregorianCalendar to;
        HashSet priorities = new HashSet(findTasksRequest.getPriority());
        HashSet statuses = new HashSet(findTasksRequest.getStatus());
        if (!priorities.isEmpty() && !priorities.contains(task.getPriority())) {
            return false;
        }
        if (!statuses.isEmpty() && !statuses.contains(StatusType.fromValue((String)task.getStatus().toString()))) {
            return false;
        }
        XMLGregorianCalendar from = findTasksRequest.getDueOnFrom();
        if (from != null) {
            Date expirationTime = task.getExpirationTime();
            if (expirationTime == null) {
                return false;
            }
            if (expirationTime.compareTo(from.toGregorianCalendar().getTime()) < 0) {
                return false;
            }
        }
        if ((to = findTasksRequest.getDueOnTo()) != null) {
            Date expirationTime = task.getExpirationTime();
            if (expirationTime == null) {
                return false;
            }
            if (expirationTime.compareTo(to.toGregorianCalendar().getTime()) > 0) {
                return false;
            }
        }
        return true;
    }
}

