/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import org.apache.commons.codec.binary.Base64;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.governance.ConfigException;
import org.overlord.sramp.governance.Governance;
import org.overlord.sramp.governance.QueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SRAMPMonitor {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    Governance governance = new Governance();
    private long interval = this.governance.getQueryInterval();
    @Resource
    private TimerService timerService;
    private Timer timer;

    public void init() {
        TimerConfig timerConfig = new TimerConfig(null, false);
        this.timer = this.timerService.createIntervalTimer(this.interval, this.interval, timerConfig);
    }

    public boolean cancel() {
        this.timer.cancel();
        return true;
    }

    @Timeout
    public synchronized void executeMonitoring(Timer timer) {
        try {
            if (this.isAppserverReady()) {
                long startTime = System.currentTimeMillis();
                QueryExecutor queryExecutor = new QueryExecutor();
                queryExecutor.execute();
                long endTime = System.currentTimeMillis();
                if (endTime - startTime > this.interval) {
                    this.log.debug("Notification background task duration exceeds the JUDDI_NOTIFICATION_INTERVAL of " + this.interval + ". Notification background task took " + (endTime - startTime) + " milliseconds.");
                } else {
                    this.log.debug("Notification background task took " + (endTime - startTime) + " milliseconds.");
                }
            } else {
                this.log.debug("Skipping current notification cycle because app server is not ready.");
            }
        }
        catch (ConfigException confEx) {
            this.log.error(confEx.getMessage());
        }
        catch (SrampClientException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isAppserverReady() throws MalformedURLException {
        boolean isReady = true;
        String serviceDocumentUrl = this.governance.getSrampUrl().toExternalForm() + "/s-ramp/servicedocument";
        isReady = this.urlExists(serviceDocumentUrl);
        if (!isReady) {
            this.log.debug("Cannot yet connect to the S-RAMP repo at: " + this.governance.getSrampUrl().toExternalForm());
        }
        return isReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean urlExists(String checkUrl) {
        HttpURLConnection checkConnection = null;
        try {
            URL checkURL = new URL(checkUrl);
            checkConnection = (HttpURLConnection)checkURL.openConnection();
            checkConnection.setRequestMethod("HEAD");
            checkConnection.setConnectTimeout(10000);
            checkConnection.setReadTimeout(10000);
            this.addAuthorization(checkConnection);
            checkConnection.connect();
            boolean bl = checkConnection.getResponseCode() == 200;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (checkConnection != null) {
                checkConnection.disconnect();
            }
        }
    }

    private void addAuthorization(HttpURLConnection connection) {
        Governance governance = new Governance();
        String username = governance.getSrampUser();
        String password = governance.getSrampPassword();
        if (username != null && password != null) {
            String b64Auth = Base64.encodeBase64String((byte[])(username + ":" + password).getBytes()).trim();
            connection.setRequestProperty("Authorization", "Basic " + b64Auth);
        } else {
            this.log.warn("No username (governance.user) and/or password (governance.password) found in the dtgov properties file.");
        }
    }
}

