/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance.services.rhq;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Header;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.ResponseSpecification;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matchers;
import org.overlord.sramp.governance.ConfigException;
import org.overlord.sramp.governance.services.rhq.CreateCBRRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RHQDeployUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    static final String APPLICATION_JSON = "application/json";
    static Header acceptJson = new Header("Accept", "application/json");
    String rhqUser;
    String rhqPassword;

    public RHQDeployUtil(String rhqUser, String rhqPassword, String rhqBaseUrl, Integer rhqPort) {
        RestAssured.baseURI = rhqBaseUrl;
        RestAssured.port = rhqPort;
        RestAssured.basePath = "/rest/";
        this.rhqUser = rhqUser;
        this.rhqPassword = rhqPassword;
        RestAssured.authentication = RestAssured.basic((String)rhqUser, (String)rhqPassword);
    }

    public Integer getGroupIdForGroup(String groupName) throws ConfigException {
        Response response = RestAssured.given().header(acceptJson).queryParam("q", new Object[]{groupName}).expect().statusCode(200).when().get("/group", new Object[0]);
        JsonPath jsonPath = response.jsonPath();
        if (!jsonPath.prettify().contains("\"id\"")) {
            throw new ConfigException("Group " + groupName + " does not exist in RHQ." + jsonPath.prettify());
        }
        int groupId = jsonPath.getInt("[0].id");
        return groupId;
    }

    public List<Integer> getServerIdsForGroup(Integer groupId) {
        Response response = RestAssured.given().header(acceptJson).pathParam("groupId", (Object)groupId).expect().statusCode(200).when().get("/group/{groupId}/resources", new Object[0]);
        JsonPath jsonPath = response.jsonPath();
        List resourceIds = (List)jsonPath.get("resourceId");
        return resourceIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(Integer as7Id, byte[] bytes, String artifactName) throws IOException {
        String handle = null;
        try {
            handle = RestAssured.given().auth().preemptive().basic(this.rhqUser, this.rhqPassword).body(bytes).contentType(ContentType.BINARY).header(acceptJson).expect().statusCode(Matchers.isOneOf((Object[])new Integer[]{200, 201})).body("value", Matchers.startsWith((String)"rhq-rest-"), new Object[0]).body("value", Matchers.endsWith((String)".bin"), new Object[0]).when().post("/content/fresh", new Object[0]).jsonPath().getString("value");
            CreateCBRRequest resource = new CreateCBRRequest();
            resource.setParentId(as7Id);
            resource.setResourceName(artifactName);
            resource.setTypeName("Deployment");
            resource.setPluginName("JBossAS7");
            resource.getPluginConfig().put("path", "deployment");
            resource.getResourceConfig().put("runtimeName", artifactName);
            Response response = ((ResponseSpecification)RestAssured.given().body((Object)resource).queryParam("handle", new Object[]{handle}).contentType(ContentType.JSON).header(acceptJson).expect().statusCode(Matchers.isOneOf((Object[])new Integer[]{200, 201, 302})).log().everything()).when().post("/resource", new Object[0]);
            int status = response.getStatusCode();
            String location = response.getHeader("Location");
            assert (location != null);
            while (status == 302) {
                response = RestAssured.given().header(acceptJson).expect().statusCode(Matchers.isOneOf((Object[])new Integer[]{200, 201, 302})).when().get(location, new Object[0]);
                status = response.getStatusCode();
            }
            int createdResourceId = response.jsonPath().getInt("resourceId");
            assert (createdResourceId != -1);
        }
        catch (Throwable throwable) {
            this.removeContent(handle, false);
            throw throwable;
        }
        this.removeContent(handle, false);
    }

    private void removeContent(String handle, boolean validate) {
        RestAssured.given().pathParam("handle", (Object)handle).header(acceptJson).expect().statusCode(204).log().ifError().when().delete("/content/{handle}", new Object[0]);
    }

    public void wipeArchiveIfNecessary(String artifactName, Integer groupId) {
        List resources = (List)RestAssured.given().queryParam("q", new Object[]{artifactName}).queryParam("category", new Object[]{"SERVICE"}).queryParam("group", new Object[]{groupId}).header(acceptJson).expect().when().get("/resource", new Object[0]).as(List.class);
        String.format("archive ? on resource ? , args", new Object[0]);
        this.logger.info(String.format("RHQ manages %1$s servers in group with id '%2$s' with artifact name '%3$s'", resources.size(), groupId, artifactName));
        for (int i = 0; i < resources.size(); ++i) {
            try {
                int resourceId = (Integer)((Map)resources.get(i)).get("resourceId");
                this.logger.info(String.format("Deleting %1$s from Server with Id %2$s", artifactName, resourceId));
                RestAssured.given().pathParam("id", (Object)resourceId).queryParam("physical", new Object[]{"true"}).expect().statusCode(204).when().delete("/resource/{id}", new Object[0]);
                continue;
            }
            catch (Throwable t) {
                this.logger.error("Could not delete archive from resource ");
                this.logger.error(t.getMessage());
            }
        }
    }
}

