/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance.shell.commands;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientRequestFactory;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.overlord.sramp.atom.services.brms.assets.Assets;
import org.overlord.sramp.atom.services.brms.packages.Packages;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.api.Arguments;
import org.overlord.sramp.shell.api.ShellContext;
import org.overlord.sramp.shell.api.SimpleShellContext;

public class Pkg2SrampCommand
extends AbstractShellCommand {
    private ClientRequestFactory fac = null;

    public static void main(String[] args) throws Exception {
        String brmsPackageName = "SRAMPPackage";
        String tag = "LATEST";
        String brmsBaseUrl = "http://localhost:8080/drools-guvnor";
        String brmsUserId = "admin";
        String brmsPassword = "admin";
        if (args.length > 0) {
            brmsPackageName = args[0];
        }
        if (args.length > 1) {
            tag = args[1];
        }
        if (args.length > 2) {
            brmsBaseUrl = args[2];
        }
        if (args.length > 3) {
            brmsUserId = args[3];
        }
        if (args.length > 4) {
            brmsPassword = args[4];
        }
        StringBuilder argLine = new StringBuilder();
        argLine.append(brmsPackageName).append(" ").append(tag).append(" ").append(brmsBaseUrl).append(" ").append(brmsUserId).append(" ").append(brmsPassword);
        SrampAtomApiClient client = new SrampAtomApiClient("http://localhost:8080/s-ramp-server");
        QName clientVarName = new QName("s-ramp", "client");
        Pkg2SrampCommand cmd = new Pkg2SrampCommand();
        SimpleShellContext context = new SimpleShellContext();
        context.setVariable(clientVarName, (Object)client);
        cmd.setArguments(new Arguments(argLine.toString()));
        cmd.setContext((ShellContext)context);
        cmd.execute();
    }

    public void printUsage() {
        this.print("brms:pkg2sramp <brmsPackageName> <tag> <brmsBaseUrl> <brmsUserId> <brmsPassword>", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'pkg2sramp' command copies a named BRMS package from the", new Object[0]);
        this.print("BRMS system and uploads it to the S-RAMP repository.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usage:", new Object[0]);
        this.print("> brms:pkg2sramp SRAMPPackage LATEST http://localhost:8080/drools-guvnor admin admin", new Object[0]);
    }

    public void execute() throws Exception {
        QName clientVarName = new QName("s-ramp", "client");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print("No S-RAMP repository connection is currently open.", new Object[0]);
            return;
        }
        String brmsPackageName = this.optionalArgument(0, "SRAMPPackage");
        String tag = this.optionalArgument(1, "LATEST");
        String brmsBaseUrl = this.optionalArgument(2, "http://localhost:8080/drools-guvnor");
        String brmsUserId = this.optionalArgument(3, "admin");
        String brmsPassword = this.optionalArgument(4, "admin");
        this.print("Copying BRMS package to S-RAMP using: ", new Object[0]);
        this.print("   brmsPackageName..: %1$s", new Object[]{brmsPackageName});
        this.print("   tag .............: %1$s", new Object[]{tag});
        this.print("   brmsBaseUrl......: %1$s", new Object[]{brmsBaseUrl});
        this.print("   brmsUserId.......: %1$s", new Object[]{brmsUserId});
        this.print("   brmsPassword.....: %1$s", new Object[]{brmsPassword});
        String brmsURLStr = brmsBaseUrl + "/rest/packages/";
        boolean brmsExists = this.urlExists(brmsURLStr, brmsUserId, brmsPassword);
        if (!brmsExists) {
            this.print("Can't find BRMS endpoint: " + brmsURLStr, new Object[0]);
            return;
        }
        try {
            this.uploadBrmsPackage(brmsBaseUrl, brmsPackageName, tag, brmsUserId, brmsPassword, client);
        }
        catch (Exception e) {
            this.print("FAILED to copy the BRMS package.", new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
        }
        this.print("**********************************************************************", new Object[0]);
    }

    public boolean urlExists(String checkUrl, String user, String password) {
        try {
            URL checkURL = new URL(checkUrl);
            HttpURLConnection checkConnection = (HttpURLConnection)checkURL.openConnection();
            checkConnection.setRequestMethod("GET");
            checkConnection.setRequestProperty("Accept", "application/xml");
            checkConnection.setConnectTimeout(10000);
            checkConnection.setReadTimeout(10000);
            this.applyAuth(checkConnection, user, password);
            checkConnection.connect();
            return checkConnection.getResponseCode() == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void applyAuth(HttpURLConnection connection, String user, String password) {
        String auth = user + ":" + password;
        connection.setRequestProperty("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])auth.getBytes())));
    }

    public void uploadBrmsPackage(String brmsBaseUrl, String pkgName, String tag, String userId, String password, SrampAtomApiClient client) throws Exception {
        String urlStr = brmsBaseUrl + "/org.drools.guvnor.Guvnor/package/" + pkgName + "/" + tag;
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userId, password);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)credentials);
        ApacheHttpClient4Executor clientExecutor = new ApacheHttpClient4Executor((HttpClient)httpClient);
        this.fac = new ClientRequestFactory((ClientExecutor)clientExecutor, new URI(brmsBaseUrl));
        Map brmsPkgMap = this.getPkgsFromBrms(brmsBaseUrl);
        if (!brmsPkgMap.containsKey(pkgName)) {
            this.print("Brms contains the following BRMS Packages", new Object[0]);
            for (String name : brmsPkgMap.keySet()) {
                this.print(" * " + name, new Object[0]);
            }
            throw new Exception("Could not find package with name " + pkgName + " in BRMS");
        }
        Packages.Package brmsPkg = (Packages.Package)brmsPkgMap.get(pkgName);
        this.print("Located BRMS package '" + pkgName + "' :", new Object[0]);
        this.print("   UUID ............: " + brmsPkg.getMetadata().getUuid(), new Object[0]);
        this.print("   Version .........: " + brmsPkg.getMetadata().getVersionNumber(), new Object[0]);
        this.print("   Author ..........: " + brmsPkg.getAuthor(), new Object[0]);
        this.print("   Last published ..: " + brmsPkg.getPublished(), new Object[0]);
        this.print("   Description .....: " + brmsPkg.getDescription(), new Object[0]);
        ExtendedArtifactType extendedArtifactType = (ExtendedArtifactType)ArtifactType.fromFileExtension((String)"pkg").newArtifactInstance();
        extendedArtifactType.setUuid(brmsPkg.getMetadata().getUuid());
        extendedArtifactType.setName(pkgName + ".pkg");
        Property assetsProperty = new Property();
        assetsProperty.setPropertyName("AssetInfoXML");
        String assetsXml = this.getAssetsStringFromBrms(brmsBaseUrl, pkgName);
        String srampUrl = client.getEndpoint().substring(0, client.getEndpoint().lastIndexOf("/"));
        assetsXml = assetsXml.replaceAll(brmsBaseUrl, srampUrl + "/brms");
        assetsProperty.setPropertyValue(assetsXml);
        extendedArtifactType.getProperty().add(assetsProperty);
        this.print("Reading " + pkgName + " from url " + urlStr, new Object[0]);
        ClientResponse pkgResponse = this.getInputStream(urlStr);
        InputStream content = (InputStream)pkgResponse.getEntity();
        BaseArtifactType artifact = client.uploadArtifact((BaseArtifactType)extendedArtifactType, content);
        IOUtils.closeQuietly((InputStream)content);
        this.print("Uploaded " + pkgName + " UUID=" + artifact.getUuid(), new Object[0]);
        Assets assets = this.getAssetsFromBrms(brmsBaseUrl, pkgName);
        for (Assets.Asset asset : assets.getAsset()) {
            if ("package".equalsIgnoreCase(asset.getMetadata().getFormat())) continue;
            String fileName = asset.getTitle() + "." + asset.getMetadata().getFormat().toLowerCase();
            String uuid = asset.getMetadata().getUuid();
            String assetURLStr = brmsBaseUrl + "/rest/packages/" + pkgName + "/assets/" + asset.getTitle() + "/binary";
            ClientResponse assetResponse = this.getInputStream(assetURLStr);
            InputStream assetInputStream = (InputStream)assetResponse.getEntity();
            ArtifactType artifactType = ArtifactType.fromFileExtension((String)asset.getMetadata().getFormat());
            BaseArtifactType baseArtifactType = artifactType.newArtifactInstance();
            baseArtifactType.setName(fileName);
            baseArtifactType.setUuid(uuid);
            BaseArtifactType assetArtifact = client.uploadArtifact(baseArtifactType, assetInputStream);
            IOUtils.closeQuietly((InputStream)assetInputStream);
            this.print("Uploaded asset " + assetArtifact.getUuid() + " " + assetArtifact.getName(), new Object[0]);
        }
        this.print("OK", new Object[0]);
    }

    protected Map<String, Packages.Package> getPkgsFromBrms(String brmsBaseUrl) throws Exception {
        String pkgsUrl = brmsBaseUrl + "/rest/packages/";
        this.print("Reading from " + pkgsUrl + " to find all packages in BRMS..", new Object[0]);
        ClientRequest pkgsRequest = this.fac.createRequest(pkgsUrl);
        pkgsRequest.accept("application/xml");
        ClientResponse pkgsResponse = pkgsRequest.get(Packages.class);
        if (pkgsResponse.getStatus() != 200) {
            throw new Exception("Failed : HTTP error code : " + pkgsResponse.getStatus());
        }
        Packages packages = (Packages)pkgsResponse.getEntity();
        HashMap<String, Packages.Package> brmsPkgMap = new HashMap<String, Packages.Package>();
        for (Packages.Package brmsPkg : packages.getPackage()) {
            brmsPkgMap.put(brmsPkg.getTitle(), brmsPkg);
        }
        return brmsPkgMap;
    }

    protected String getAssetsStringFromBrms(String brmsBaseUrl, String pkgName) throws Exception {
        String assetsUrl = brmsBaseUrl + "/rest/packages/" + pkgName + "/assets";
        this.print("Reading from " + assetsUrl + " to find all assets in package " + pkgName, new Object[0]);
        ClientRequest assetsRequest = this.fac.createRequest(assetsUrl);
        assetsRequest.accept("application/xml");
        ClientResponse assetsResponse = assetsRequest.get(String.class);
        if (assetsResponse.getStatus() != 200) {
            throw new Exception("Failed : HTTP error code : " + assetsResponse.getStatus());
        }
        String assetsXml = (String)assetsResponse.getEntity();
        return assetsXml;
    }

    protected Assets getAssetsFromBrms(String brmsBaseUrl, String pkgName) throws Exception {
        String assetsUrl = brmsBaseUrl + "/rest/packages/" + pkgName + "/assets";
        this.print("Reading from " + assetsUrl + " to find all assets in package " + pkgName, new Object[0]);
        ClientRequest assetsRequest = this.fac.createRequest(assetsUrl);
        assetsRequest.accept("application/xml");
        ClientResponse assetsResponse = assetsRequest.get(Assets.class);
        if (assetsResponse.getStatus() != 200) {
            throw new Exception("Failed : HTTP error code : " + assetsResponse.getStatus());
        }
        Assets assets = (Assets)assetsResponse.getEntity();
        return assets;
    }

    public ClientResponse<InputStream> getInputStream(String url) throws Exception {
        ClientRequest request = this.fac.createRequest(url);
        ClientResponse response = request.get(InputStream.class);
        if (response.getStatus() != 200) {
            throw new Exception("Failed : HTTP error code : " + response.getStatus());
        }
        return response;
    }
}

