/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.jbpm.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceUnit;
import javax.transaction.UserTransaction;
import org.kie.internal.task.api.UserGroupCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ApplicationScopedProducer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private UserGroupCallback usergroupCallback;
    @PersistenceUnit(unitName="org.overlord.dtgov.jbpm")
    private EntityManagerFactory emf;

    @ApplicationScoped
    @Produces
    public UserGroupCallback produceUserGroupCallback() {
        return this.usergroupCallback;
    }

    @Produces
    public EntityManagerFactory getEntityManagerFactory() {
        if (this.emf == null) {
            this.emf = Persistence.createEntityManagerFactory((String)"org.overlord.dtgov.jbpm");
        }
        return this.emf;
    }

    @Produces
    @ApplicationScoped
    public EntityManager getEntityManager() {
        EntityManager em = this.getEntityManagerFactory().createEntityManager();
        EntityManager emProxy = (EntityManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{EntityManager.class}, (InvocationHandler)new EmInvocationHandler(em));
        return emProxy;
    }

    @ApplicationScoped
    public void commitAndClose(@Disposes EntityManager em) {
        try {
            em.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class EmInvocationHandler
    implements InvocationHandler {
        private EntityManager delegate;

        EmInvocationHandler(EntityManager em) {
            this.delegate = em;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            this.joinTransactionIfNeeded();
            return method.invoke((Object)this.delegate, args);
        }

        private void joinTransactionIfNeeded() {
            try {
                UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
                if (ut.getStatus() == 0) {
                    this.delegate.joinTransaction();
                }
            }
            catch (NamingException e) {
                ApplicationScopedProducer.this.logger.debug(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                ApplicationScopedProducer.this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

