/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.commons.io.IOUtils;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.kie.api.builder.ReleaseId;
import org.kie.scanner.MavenRepository;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.overlord.dtgov.server.i18n.Messages;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.governance.Governance;
import org.overlord.sramp.governance.SlashDecoder;
import org.overlord.sramp.governance.SrampAtomApiClientFactory;
import org.overlord.sramp.governance.Target;
import org.overlord.sramp.governance.ValueEntity;
import org.overlord.sramp.governance.services.MavenRepoUtil;
import org.overlord.sramp.governance.services.rhq.RHQDeployUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/deploy")
public class DeploymentResource {
    private static Logger logger = LoggerFactory.getLogger(DeploymentResource.class);

    @POST
    @Path(value="{target}/{uuid}")
    @Produces(value={"application/xml"})
    public Map<String, ValueEntity> deploy(@Context HttpServletRequest request, @PathParam(value="target") String targetRef, @PathParam(value="uuid") String uuid) throws Exception {
        String deploymentTarget;
        Target target;
        BaseArtifactType artifact;
        SrampAtomApiClient client;
        HashMap<String, ValueEntity> results;
        block10: {
            Governance governance = new Governance();
            results = new HashMap<String, ValueEntity>();
            targetRef = SlashDecoder.decode(targetRef);
            uuid = SlashDecoder.decode(uuid);
            client = SrampAtomApiClientFactory.createAtomApiClient();
            artifact = client.getArtifactMetaData(uuid);
            target = governance.getTargets().get(targetRef);
            if (target == null) {
                logger.error(Messages.i18n.format("DeploymentResource.NoTarget", new Object[]{targetRef}));
                throw new SrampAtomException(Messages.i18n.format("DeploymentResource.NoTarget", new Object[]{targetRef}));
            }
            BaseArtifactType prevVersionArtifact = this.getCurrentlyDeployedVersion(client, artifact, target);
            if (prevVersionArtifact != null) {
                this.undeploy(client, prevVersionArtifact, target);
            }
            deploymentTarget = target.getType().toString() + ":";
            try {
                if (target.getType() == Target.TYPE.COPY) {
                    deploymentTarget = deploymentTarget + this.deployCopy(artifact, target, client);
                    break block10;
                }
                if (target.getType() == Target.TYPE.AS_CLI) {
                    deploymentTarget = deploymentTarget + this.deployCLI(artifact, target, client);
                    break block10;
                }
                if (target.getType() == Target.TYPE.MAVEN) {
                    deploymentTarget = deploymentTarget + this.deployMaven(artifact, target, client);
                    break block10;
                }
                if (target.getType() == Target.TYPE.RHQ) {
                    deploymentTarget = deploymentTarget + this.deployRHQ(artifact, target, client);
                    break block10;
                }
                throw new Exception(Messages.i18n.format("DeploymentResource.TargetTypeNotFound", new Object[]{target.getType()}));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                results.put("status", new ValueEntity("fail"));
                results.put("message", new ValueEntity(e.getMessage()));
                return results;
            }
        }
        String deploymentClassifier = target.getClassifier();
        try {
            artifact = client.getArtifactMetaData(uuid);
            artifact.getClassifiedBy().add(deploymentClassifier);
            client.updateArtifactMetaData(artifact);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        results.put("status", new ValueEntity("success"));
        results.put("target", new ValueEntity(deploymentTarget));
        return results;
    }

    protected BaseArtifactType getCurrentlyDeployedVersion(SrampAtomApiClient client, BaseArtifactType artifact, Target target) throws Exception {
        BaseArtifactType currentVersionArtifact = null;
        String classifier = target.getClassifier();
        String mavenArtifactId = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.artifactId");
        String mavenGroupId = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.groupId");
        if (mavenArtifactId != null && mavenGroupId != null) {
            QueryResultSet resultSet = client.buildQuery("/s-ramp[@maven.artifactId = ? and @maven.groupId = ? and s-ramp:exactlyClassifiedByAllOf(., ?)]").parameter(mavenArtifactId).parameter(mavenGroupId).parameter(classifier).count(2).query();
            if (resultSet.size() == 2L) {
                throw new Exception(Messages.i18n.format("DeploymentResource.MultipleMavenDeployments", new Object[]{target.getName(), artifact.getName()}));
            }
            if (resultSet.size() == 1L) {
                currentVersionArtifact = client.getArtifactMetaData(resultSet.get(0));
            }
        }
        if (currentVersionArtifact == null) {
            String name = artifact.getName();
            QueryResultSet resultSet = client.buildQuery("/s-ramp[@name = ? and s-ramp:exactlyClassifiedByAllOf(., ?)]").parameter(name).parameter(classifier).count(2).query();
            if (resultSet.size() == 2L) {
                throw new Exception(Messages.i18n.format("DeploymentResource.MultipleSimpleDeployments", new Object[]{target.getName(), artifact.getName()}));
            }
            if (resultSet.size() == 1L) {
                currentVersionArtifact = client.getArtifactMetaData(resultSet.get(0));
            }
        }
        if (currentVersionArtifact == null) {
            // empty if block
        }
        return currentVersionArtifact;
    }

    protected void undeploy(SrampAtomApiClient client, BaseArtifactType prevVersionArtifact, Target target) throws Exception {
        QueryResultSet resultSet = client.buildQuery("/s-ramp/ext/UndeploymentInformation[describesDeployment[@uuid = ?] and @deploy.target = ?]").parameter(prevVersionArtifact.getUuid()).parameter(target.getName()).count(2).query();
        if (resultSet.size() == 1L) {
            BaseArtifactType undeployInfo = client.getArtifactMetaData(resultSet.get(0));
            Target.TYPE type = Target.TYPE.valueOf(SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.type"));
            switch (type) {
                case AS_CLI: {
                    this.undeployCLI(client, prevVersionArtifact, undeployInfo, target);
                    break;
                }
                case COPY: {
                    this.undeployCopy(client, prevVersionArtifact, undeployInfo, target);
                    break;
                }
                case MAVEN: {
                    break;
                }
                case RHQ: {
                    this.undeployRHQ(client, prevVersionArtifact, undeployInfo, target);
                    break;
                }
            }
            String deploymentClassifier = SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.classifier");
            prevVersionArtifact = client.getArtifactMetaData(ArtifactType.valueOf((BaseArtifactType)prevVersionArtifact), prevVersionArtifact.getUuid());
            prevVersionArtifact.getClassifiedBy().remove(deploymentClassifier);
            client.updateArtifactMetaData(prevVersionArtifact);
            client.deleteArtifact(undeployInfo.getUuid(), ArtifactType.valueOf((BaseArtifactType)undeployInfo));
        } else {
            logger.warn(Messages.i18n.format("DeploymentResource.UndeploymentInfoNotFound", new Object[]{prevVersionArtifact.getName()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String deployCopy(BaseArtifactType artifact, Target target, SrampAtomApiClient client) throws Exception {
        String string;
        InputStream is = null;
        FileOutputStream os = null;
        try {
            File file;
            is = client.getArtifactContent(ArtifactType.valueOf((BaseArtifactType)artifact), artifact.getUuid());
            File deployDir = new File(target.getDeployDir());
            if (!deployDir.exists()) {
                logger.info(Messages.i18n.format("DeploymentResource.CreatingDeployDir", new Object[]{deployDir}));
                deployDir.mkdirs();
            }
            String deploymentName = artifact.getName();
            String mavenId = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.artifactId");
            String version = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.version");
            String classifier = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.classifier");
            String type = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.type");
            if (mavenId != null) {
                StringBuilder nameBuilder = new StringBuilder();
                nameBuilder.append(mavenId);
                nameBuilder.append("-");
                nameBuilder.append(version);
                if (classifier != null) {
                    nameBuilder.append("-");
                    nameBuilder.append(classifier);
                }
                nameBuilder.append(".");
                nameBuilder.append(type);
                deploymentName = nameBuilder.toString();
            }
            if ((file = new File(deployDir + "/" + deploymentName)).exists()) {
                file.delete();
            }
            file.createNewFile();
            os = new FileOutputStream(file);
            IOUtils.copy((InputStream)is, (OutputStream)os);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("deploy.copy.file", file.getCanonicalPath());
            this.recordUndeploymentInfo(artifact, target, props, client);
            string = file.getAbsolutePath();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)os);
        IOUtils.closeQuietly((InputStream)is);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String deployMaven(BaseArtifactType artifact, Target target, SrampAtomApiClient client) throws Exception {
        String string;
        InputStream isJar = null;
        InputStream isPom = null;
        FileOutputStream osJar = null;
        FileOutputStream osPom = null;
        InputStream isPom2 = null;
        try {
            String mavenArtifactId = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.artifactId");
            String mavenGroupId = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.groupId");
            String mavenVersion = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.version");
            if (mavenArtifactId == null || mavenGroupId == null || mavenVersion == null) {
                throw new Exception(Messages.i18n.format("DeploymentResource.MissingMavenProps", new Object[]{artifact.getUuid()}));
            }
            String pomName = artifact.getName().substring(0, artifact.getName().lastIndexOf(".")) + ".pom";
            QueryResultSet queryResultSet = client.buildQuery("/s-ramp[@name = ?]").parameter(pomName).query();
            if (queryResultSet.size() == 0L) {
                throw new Exception(Messages.i18n.format("DeploymentResource.MissingPom", new Object[]{artifact.getUuid(), pomName}));
            }
            BaseArtifactType pomArtifact = null;
            for (ArtifactSummary artifactSummary2 : queryResultSet) {
                pomArtifact = client.getArtifactMetaData(artifactSummary2);
                String pomMavenArtifactId = SrampModelUtils.getCustomProperty((BaseArtifactType)pomArtifact, (String)"maven.artifactId");
                String pomMavenGroupId = SrampModelUtils.getCustomProperty((BaseArtifactType)pomArtifact, (String)"maven.groupId");
                String pomMavenVersion = SrampModelUtils.getCustomProperty((BaseArtifactType)pomArtifact, (String)"maven.version");
                if (mavenArtifactId.equals(pomMavenArtifactId) && mavenGroupId.equals(pomMavenGroupId) && mavenVersion.equals(pomMavenVersion)) break;
                pomArtifact = null;
            }
            if (pomArtifact == null) {
                throw new Exception(Messages.i18n.format("DeploymentResource.IncorrectPom", new Object[]{artifact.getUuid(), pomName}));
            }
            ArtifactType pomType = ArtifactType.valueOf(pomArtifact);
            isPom = client.getArtifactContent(pomType, pomArtifact.getUuid());
            String name = pomArtifact.getName();
            File pomFile = new File(System.getProperty("java.io.tmpdir") + "/" + name);
            osPom = new FileOutputStream(pomFile);
            IOUtils.copy((InputStream)isPom, (OutputStream)osPom);
            IOUtils.closeQuietly((InputStream)isPom);
            IOUtils.closeQuietly((OutputStream)osPom);
            isJar = client.getArtifactContent(ArtifactType.valueOf((BaseArtifactType)artifact), artifact.getUuid());
            name = artifact.getName();
            File jarFile = new File(System.getProperty("java.io.tmpdir") + "/" + name);
            osJar = new FileOutputStream(jarFile);
            IOUtils.copy((InputStream)isJar, (OutputStream)osJar);
            IOUtils.closeQuietly((InputStream)isJar);
            IOUtils.closeQuietly((OutputStream)osJar);
            isPom2 = client.getArtifactContent(pomType, pomArtifact.getUuid());
            MavenRepoUtil util = new MavenRepoUtil();
            MavenRepository repo = util.getMavenReleaseRepo(target.getMavenUrl(), target.isReleaseEnabled(), target.isSnapshotEnabled(), isPom2);
            ReleaseIdImpl releaseId = new ReleaseIdImpl(mavenArtifactId, mavenGroupId, mavenVersion);
            repo.deployArtifact((ReleaseId)releaseId, jarFile, pomFile);
            string = target.getMavenUrl();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(isPom);
            IOUtils.closeQuietly(isPom2);
            IOUtils.closeQuietly(isJar);
            IOUtils.closeQuietly(osPom);
            IOUtils.closeQuietly(osJar);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)isPom);
        IOUtils.closeQuietly((InputStream)isPom2);
        IOUtils.closeQuietly((InputStream)isJar);
        IOUtils.closeQuietly((OutputStream)osPom);
        IOUtils.closeQuietly((OutputStream)osJar);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String deployRHQ(BaseArtifactType artifact, Target target, SrampAtomApiClient client) throws Exception {
        String string;
        InputStream is = null;
        try {
            RHQDeployUtil rhqDeployUtil = new RHQDeployUtil(target.getUser(), target.getPassword(), target.getRhqBaseUrl(), target.getPort());
            Integer rhqGroupId = rhqDeployUtil.getGroupIdForGroup(target.getName());
            rhqDeployUtil.wipeArchiveIfNecessary(artifact.getName(), rhqGroupId);
            List<Integer> resourceIds = rhqDeployUtil.getServerIdsForGroup(rhqGroupId);
            is = client.getArtifactContent(ArtifactType.valueOf((BaseArtifactType)artifact), artifact.getUuid());
            byte[] fileContent = IOUtils.toByteArray((InputStream)is);
            for (Integer resourceId : resourceIds) {
                logger.info(Messages.i18n.format("DeploymentResource.DeployingToRHQ", new Object[]{artifact.getName(), resourceId}));
                rhqDeployUtil.deploy(resourceId, fileContent, artifact.getName());
            }
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("deploy.rhq.groupId", String.valueOf(rhqGroupId));
            props.put("deploy.rhq.baseUrl", target.getRhqBaseUrl());
            props.put("deploy.rhq.port", String.valueOf(target.getPort()));
            props.put("deploy.rhq.name", artifact.getName());
            this.recordUndeploymentInfo(artifact, target, props, client);
            string = target.getRhqBaseUrl();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String deployCLI(BaseArtifactType artifact, Target target, SrampAtomApiClient client) throws Exception {
        String string;
        InputStream is;
        block3: {
            is = null;
            FileOutputStream os = null;
            CommandContext ctx = null;
            try {
                ArtifactType type = ArtifactType.valueOf((BaseArtifactType)artifact);
                is = client.getArtifactContent(type, artifact.getUuid());
                String name = artifact.getName();
                int dot = name.lastIndexOf(".");
                File tmpFile = File.createTempFile(name.substring(0, dot), name.substring(dot));
                os = new FileOutputStream(tmpFile);
                IOUtils.copy((InputStream)is, (OutputStream)os);
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)os);
                ctx = target.getUser() == null || target.getUser().isEmpty() ? CommandContextFactory.getInstance().newCommandContext() : CommandContextFactory.getInstance().newCommandContext(target.getUser(), target.getPassword().toCharArray());
                ctx.connectController(target.getHost(), target.getPort().intValue());
                ctx.handle("deploy " + tmpFile.getAbsolutePath() + " --server-groups=" + target.getName());
                tmpFile.delete();
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("deploy.cli.serverGroups", target.getName());
                props.put("deploy.cli.host", target.getHost());
                props.put("deploy.cli.port", String.valueOf(target.getPort()));
                props.put("deploy.cli.name", tmpFile.getName());
                this.recordUndeploymentInfo(artifact, target, props, client);
                string = target.getName() + " " + target.getHost();
                if (ctx == null) break block3;
            }
            catch (Throwable throwable) {
                if (ctx != null) {
                    ctx.terminateSession();
                }
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            ctx.terminateSession();
        }
        IOUtils.closeQuietly((InputStream)is);
        return string;
    }

    protected void recordUndeploymentInfo(BaseArtifactType artifact, Target target, Map<String, String> props, SrampAtomApiClient client) throws SrampClientException, SrampAtomException {
        ExtendedArtifactType undeploymentArtifact = new ExtendedArtifactType();
        undeploymentArtifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        undeploymentArtifact.setExtendedType("UndeploymentInformation");
        undeploymentArtifact.setName(artifact.getName() + ".undeploy");
        undeploymentArtifact.setDescription(Messages.i18n.format("DeploymentResource.UndeploymentInfoDescription", new Object[]{artifact.getName()}));
        SrampModelUtils.setCustomProperty((BaseArtifactType)undeploymentArtifact, (String)"deploy.target", (String)target.getName());
        SrampModelUtils.setCustomProperty((BaseArtifactType)undeploymentArtifact, (String)"deploy.type", (String)target.getType().name());
        SrampModelUtils.setCustomProperty((BaseArtifactType)undeploymentArtifact, (String)"deploy.classifier", (String)target.getClassifier());
        if (props != null) {
            for (String propKey : props.keySet()) {
                String propVal = props.get(propKey);
                SrampModelUtils.setCustomProperty((BaseArtifactType)undeploymentArtifact, (String)propKey, (String)propVal);
            }
        }
        SrampModelUtils.addGenericRelationship((BaseArtifactType)undeploymentArtifact, (String)"describesDeployment", (String)artifact.getUuid());
        client.createArtifact((BaseArtifactType)undeploymentArtifact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeployCLI(SrampAtomApiClient client, BaseArtifactType prevVersionArtifact, BaseArtifactType undeployInfo, Target target) throws Exception {
        CommandContext ctx = null;
        try {
            String deploymentName = SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.cli.name");
            String cliHost = SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.cli.host");
            Integer cliPort = new Integer(SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.cli.port"));
            ctx = target.getUser() == null || target.getUser().isEmpty() ? CommandContextFactory.getInstance().newCommandContext() : CommandContextFactory.getInstance().newCommandContext(target.getUser(), target.getPassword().toCharArray());
            ctx.connectController(cliHost, cliPort.intValue());
            ctx.handle("undeploy " + deploymentName);
        }
        finally {
            if (ctx != null) {
                ctx.terminateSession();
            }
        }
    }

    protected void undeployCopy(SrampAtomApiClient client, BaseArtifactType prevVersionArtifact, BaseArtifactType undeployInfo, Target target) {
        File failedFile;
        File deployFile;
        String deployedFile = SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.copy.file");
        File file = new File(deployedFile);
        if (file.exists() && file.isFile()) {
            file.delete();
        }
        if ((deployFile = new File(deployedFile + ".deployed")).isFile()) {
            deployFile.delete();
        }
        if ((failedFile = new File(deployedFile + ".failed")).isFile()) {
            failedFile.delete();
        }
    }

    protected void undeployRHQ(SrampAtomApiClient client, BaseArtifactType prevVersionArtifact, BaseArtifactType undeployInfo, Target target) throws Exception {
        if (target.getUser() == null || target.getPassword() == null || target.getUser().isEmpty() || target.getPassword().isEmpty()) {
            throw new Exception(Messages.i18n.format("DeploymentResource.MissingTargetCreds", new Object[]{target.getName()}));
        }
        String baseUrl = SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.rhq.baseUrl");
        Integer port = new Integer(SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.rhq.port"));
        Integer rhqGroupId = new Integer(SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.rhq.groupId"));
        String artifactName = SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.rhq.name");
        RHQDeployUtil rhqDeployUtil = new RHQDeployUtil(target.getUser(), target.getPassword(), baseUrl, port);
        rhqDeployUtil.wipeArchiveIfNecessary(artifactName, rhqGroupId);
    }
}

