/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance.services;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandLineException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.overlord.sramp.common.test.resteasy.BaseResourceTest;
import org.overlord.sramp.common.test.resteasy.TestPortProvider;
import org.overlord.sramp.governance.ConfigException;
import org.overlord.sramp.governance.Target;
import org.overlord.sramp.governance.services.DeploymentResource;
import org.overlord.sramp.governance.services.rhq.RHQDeployUtil;

public class DeploymentResourceTest
extends BaseResourceTest {
    @BeforeClass
    public static void setUpBrms() throws Exception {
        dispatcher.getRegistry().addPerRequestResource(DeploymentResource.class);
    }

    @Test
    @Ignore
    public void testDeployCopy() {
        try {
            URL url = new URL(TestPortProvider.generateURL((String)"/deploy/copy/dev/e67e1b09-1de7-4945-a47f-45646752437a"));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                InputStream is = (InputStream)connection.getContent();
                String reply = IOUtils.toString((InputStream)is);
                System.out.println("reply=" + reply);
            } else {
                System.err.println("endpoint could not be reached");
                Assert.fail();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    @Ignore
    public void testDeployMaven() {
    }

    @Test
    @Ignore
    public void testDeployRHQ() throws IOException, ConfigException {
        Target target = new Target("stage", "http://www.jboss.org/overlord/deployment-status.owl#InDev", "rhqadmin", "rhqadmin", "http://localhost:7080");
        RHQDeployUtil rhqDeployUtil = new RHQDeployUtil(target.getUser(), target.getPassword(), target.getRhqBaseUrl(), target.getPort());
        String groupName = target.getName();
        String artifactName = "test-simple2.war";
        Integer groupId = rhqDeployUtil.getGroupIdForGroup(groupName);
        rhqDeployUtil.wipeArchiveIfNecessary(artifactName, groupId);
        List resourceIds = rhqDeployUtil.getServerIdsForGroup(groupId);
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(artifactName);
        byte[] fileContent = IOUtils.toByteArray((InputStream)is);
        IOUtils.closeQuietly((InputStream)is);
        for (Integer resourceId : resourceIds) {
            System.out.println(String.format("Deploying %1$s to RHQ Server %2$s", artifactName, resourceId));
            rhqDeployUtil.deploy(resourceId, fileContent, artifactName);
        }
        System.out.println("complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testCli() {
        CommandContext ctx = null;
        try {
            ctx = CommandContextFactory.getInstance().newCommandContext();
            String host = "localhost";
            int port = 9999;
            ctx.connectController(host, port);
            ctx.handle("deploy ~/Desktop/test-simple2.war --force");
        }
        catch (CliInitializationException e) {
            throw new IllegalStateException("Failed to initialize CLI context", e);
        }
        catch (CommandLineException e) {
            e.printStackTrace();
        }
        finally {
            ctx.terminateSession();
        }
    }

    @Test
    @Ignore
    public void testMaven() throws Exception {
    }
}

