/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.jbpm.util;

import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jbpm.kie.services.api.RuntimeDataService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.event.DeploymentEvent;
import org.jbpm.kie.services.impl.event.Undeploy;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.kie.services.impl.model.ProcessInstanceDesc;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.internal.deployment.DeployedUnit;
import org.kie.internal.deployment.DeploymentService;
import org.kie.internal.deployment.DeploymentUnit;
import org.overlord.dtgov.jbpm.util.Sramp;

@ApplicationScoped
public class ProcessEngineService {
    @Inject
    private RuntimeDataService runtimeDataService;
    @Inject
    @Sramp
    private DeploymentService deploymentService;
    @Inject
    @Undeploy
    protected Event<DeploymentEvent> undeploymentEvent;

    @ApplicationScoped
    @Produces
    public DeploymentService getDeploymentService() {
        return this.deploymentService;
    }

    public void deployUnit(KModuleDeploymentUnit unit) {
        this.deploymentService.deploy((DeploymentUnit)unit);
    }

    public void undeployUnit(KModuleDeploymentUnit unit) {
        this.deploymentService.undeploy((DeploymentUnit)unit);
    }

    public Collection<ProcessAssetDesc> getProcesses() {
        return this.runtimeDataService.getProcesses();
    }

    public ProcessInstanceDesc getProcessInstance(long processInstanceId) {
        return this.runtimeDataService.getProcessInstanceById(processInstanceId);
    }

    public Collection<ProcessInstanceDesc> getProcessInstances() {
        return this.runtimeDataService.getProcessInstances();
    }

    public Collection<ProcessAssetDesc> getProcesses(String deploymentId) {
        return this.runtimeDataService.getProcessesByDeploymentId(deploymentId);
    }

    public RuntimeManager getRuntimeManager(String deploymentId) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            return null;
        }
        return deployedUnit.getRuntimeManager();
    }

    public void closeAllRuntimeManagers() {
        for (DeployedUnit deployedUnit : this.deploymentService.getDeployedUnits()) {
            deployedUnit.getRuntimeManager().close();
            this.undeploymentEvent.fire((Object)new DeploymentEvent(deployedUnit.getDeploymentUnit().getIdentifier(), deployedUnit));
        }
    }
}

