/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.overlord.commons.config.ConfigurationFactory;
import org.overlord.commons.config.JBossServer;
import org.overlord.dtgov.common.Target;
import org.overlord.dtgov.common.exception.ConfigException;
import org.overlord.sramp.governance.NotificationDestinations;
import org.overlord.sramp.governance.Release;
import org.overlord.sramp.governance.auth.BasicAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Governance {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static String QUERY_ERROR = "governance.queries should be of the format <query>|<processId>|<param::param>\nCheck\n";
    public static String TARGET_ERROR = "governance.targets should be of the format <targetName>|<directory>\nCheck\n";
    public static String NOTIFICATION_ERROR = "governance..<email|..> should be of the format <groupName>|<fromAddress>|<destination1>,<destination2>\nCheck\n";
    public static String DEFAULT_JNDI_EMAIL_REF = "java:jboss/mail/Default";
    public static String DEFAULT_JNDI_TX_REF = "java:comp/UserTransaction";
    public static String DEFAULT_EMAIL_DOMAIN = "example.com";
    public static String DEFAULT_EMAIL_FROM = "overlord@example.com";
    public static String DEFAULT_GOVERNANCE_WORKFLOW_GROUP = "org.overlord.dtgov";
    public static String DEFAULT_GOVERNANCE_WORKFLOW_NAME = "dtgov-workflows";
    public static String DEFAULT_GOVERNANCE_WORKFLOW_VERSION = "1.0.0";
    public static String DEFAULT_GOVERNANCE_WORKFLOW_PACKAGE = "SRAMPPackage";
    public static String DEFAULT_GOVERNANCE_WORKFLOW_KSESSION = "ksessionSRAMP";
    public static String DEFAULT_GOVERNANCE_USER = "admin";
    public static String DEFAULT_GOVERNANCE_PASSWORD = "overlord";
    public static String DEFAULT_RHQ_USER = "rhqadmin";
    public static String DEFAULT_RHQ_PASSWORD = "rhqadmin";
    public static String DEFAULT_RHQ_BASEURL = "http://localhost:7080";
    protected static Configuration configuration;

    protected Configuration getConfiguration() {
        return configuration;
    }

    public String validate() throws ConfigException {
        StringBuffer configuration = new StringBuffer();
        try {
            configuration.append("Governance configuration:").append("\n");
            configuration.append("governance.bpm.url: " + this.getBpmUrl()).append("\n");
            configuration.append("governance.bpm.user: " + this.getBpmUser()).append("\n");
            configuration.append("governance.bpm.password: " + this.getBpmPassword().replaceAll(".", "*")).append("\n");
            configuration.append("sramp.repo.url: " + this.getSrampUrl()).append("\n");
            configuration.append("sramp.repo.user: " + this.getSrampUser()).append("\n");
            configuration.append("sramp.repo.password: " + this.getSrampPassword()).append("\n");
            configuration.append("sramp.repo.validating: " + this.getSrampValidating()).append("\n");
            configuration.append("sramp.repo.auth.provider: " + this.getSrampAuthProvider()).append("\n");
            int i = 1;
            for (String name : this.getTargets().keySet()) {
                configuration.append("Target ").append(i++).append("\n");
                configuration.append(this.getTargets().get(name).toString()).append("\n\n");
            }
            this.log.debug(configuration.toString());
            return configuration.toString();
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (MalformedURLException e) {
            throw new ConfigException((Throwable)e);
        }
        catch (Exception e) {
            throw new ConfigException((Throwable)e);
        }
    }

    public String getBpmUser() {
        return this.getConfiguration().getString("governance.bpm.user", DEFAULT_GOVERNANCE_USER);
    }

    public String getBpmPassword() {
        return this.getConfiguration().getString("governance.bpm.password", DEFAULT_GOVERNANCE_PASSWORD);
    }

    public String getOverlordUser() {
        return this.getConfiguration().getString("governance.user", DEFAULT_GOVERNANCE_USER);
    }

    public String getOverlordPassword() {
        return this.getConfiguration().getString("governance.password", DEFAULT_GOVERNANCE_PASSWORD);
    }

    public String getRhqUser() {
        return this.getConfiguration().getString("rhq.rest.user", DEFAULT_RHQ_USER);
    }

    public String getRhqPassword() {
        return this.getConfiguration().getString("rhq.rest.password", DEFAULT_GOVERNANCE_PASSWORD);
    }

    public URL getBpmUrl() throws MalformedURLException {
        return new URL(this.getConfiguration().getString("governance.bpm.url", JBossServer.getBaseUrl() + "/gwt-console-server"));
    }

    public URL getSrampUrl() throws MalformedURLException {
        return new URL(this.getConfiguration().getString("sramp.repo.url", JBossServer.getBaseUrl() + "/s-ramp-server"));
    }

    public String getSrampUser() {
        return this.getConfiguration().getString("sramp.repo.user", "admin");
    }

    public String getSrampPassword() {
        return this.getConfiguration().getString("sramp.repo.password", "overlord");
    }

    public Class<?> getSrampAuthProvider() throws Exception {
        String authProviderClassName = this.getConfiguration().getString("sramp.repo.auth.provider", BasicAuthenticationProvider.class.getName());
        if (authProviderClassName == null) {
            return null;
        }
        return Class.forName(authProviderClassName);
    }

    public boolean getSrampValidating() throws Exception {
        return "true".equals(this.getConfiguration().getString("sramp.repo.validating", "false"));
    }

    public String getGovernanceUrl() {
        return this.getConfiguration().getString("governance.url", JBossServer.getBaseUrl() + "/dtgov");
    }

    public String getDTGovUiUrl() {
        return this.getConfiguration().getString("dtgov.ui.url", JBossServer.getBaseUrl() + "/dtgov-ui");
    }

    public Map<String, Target> getTargets() throws ConfigException {
        HashMap<String, Target> targets = new HashMap<String, Target>();
        String[] targetStrings = this.getConfiguration().getStringArray("governance.targets");
        StringBuffer errors = new StringBuffer(TARGET_ERROR);
        boolean hasErrors = false;
        for (String targetString : targetStrings) {
            Target target;
            String[] info = targetString.split("\\|");
            if (info.length != 4) {
                hasErrors = true;
                errors.append(targetString).append("\n");
            }
            if (hasErrors) continue;
            String name = info[0];
            String classifier = info[1];
            String type = info[2];
            if (Target.TYPE.COPY.toString().equalsIgnoreCase(type)) {
                Target target2 = new Target(name, classifier, info[3]);
                targets.put(target2.getName(), target2);
                continue;
            }
            if (Target.TYPE.RHQ.toString().equalsIgnoreCase(type)) {
                String rhqConfigStr = info[3].replaceAll("\\{rhq.user\\}", DEFAULT_RHQ_USER).replaceAll("\\{rhq.password\\}", DEFAULT_RHQ_PASSWORD).replaceAll("\\{rhq.baseUrl\\}", DEFAULT_RHQ_BASEURL);
                String[] rhqConfig = rhqConfigStr.split("\\:\\:");
                Target target3 = null;
                if (rhqConfig.length == 3) {
                    target3 = new Target(name, classifier, rhqConfig[0], rhqConfig[1], rhqConfig[2], "JBossAS7");
                } else if (rhqConfig.length == 4) {
                    target3 = new Target(name, classifier, rhqConfig[0], rhqConfig[1], rhqConfig[2], rhqConfig[3]);
                } else {
                    hasErrors = true;
                    errors.append(rhqConfigStr).append("\n");
                }
                if (hasErrors) continue;
                targets.put(target3.getName(), target3);
                continue;
            }
            if (Target.TYPE.AS_CLI.toString().equalsIgnoreCase(type)) {
                String[] cliConfig = info[3].split("\\:\\:");
                target = new Target(name, classifier, cliConfig[0], cliConfig[1], cliConfig[2], Integer.valueOf(cliConfig[3]));
                targets.put(target.getName(), target);
                continue;
            }
            if (!Target.TYPE.MAVEN.toString().equalsIgnoreCase(type)) continue;
            String[] mvnConfig = info[3].split("\\:\\:");
            target = new Target(name, classifier, mvnConfig[0], Boolean.parseBoolean(mvnConfig[1]), Boolean.parseBoolean(mvnConfig[2]));
            targets.put(target.getName(), target);
        }
        if (hasErrors) {
            throw new ConfigException(errors.toString());
        }
        return targets;
    }

    public Map<String, NotificationDestinations> getNotificationDestinations(String channel) throws ConfigException {
        HashMap<String, NotificationDestinations> destinationMap = new HashMap<String, NotificationDestinations>();
        String[] destinationStrings = this.getConfiguration().getStringArray("governance." + channel);
        StringBuffer errors = new StringBuffer(NOTIFICATION_ERROR);
        boolean hasErrors = false;
        for (String destinationString : destinationStrings) {
            String[] info = destinationString.split("\\|");
            if (info.length != 3) {
                hasErrors = true;
                errors.append(destinationString).append("\n");
            }
            if (hasErrors) continue;
            NotificationDestinations destination = new NotificationDestinations(info[0], info[1], info[2]);
            destinationMap.put(destination.getName(), destination);
        }
        if (hasErrors) {
            throw new ConfigException(errors.toString());
        }
        return destinationMap;
    }

    public long getQueryInterval() {
        return this.getConfiguration().getLong("governance.query.interval", 300000L);
    }

    public long getAcceptableLagtime() {
        return configuration.getLong("governance.acceptable.lagtime", 1000L);
    }

    public String getJNDIEmailName() {
        return this.getConfiguration().getString("governance.jndi.email.reference", DEFAULT_JNDI_EMAIL_REF);
    }

    public String getJNDIUserTxName() {
        return this.getConfiguration().getString("governance.jndi.userTx.reference", DEFAULT_JNDI_TX_REF);
    }

    public String getDefaultEmailDomain() {
        return this.getConfiguration().getString("governance.email.domain", DEFAULT_EMAIL_DOMAIN);
    }

    public String getDefaultEmailFromAddress() {
        return this.getConfiguration().getString("governance.email.from", DEFAULT_EMAIL_FROM);
    }

    public String getSrampWagonVersion() {
        return Release.getVersionFromManifest("s-ramp-wagon");
    }

    public Boolean getSrampWagonSnapshots() {
        return this.getConfiguration().getBoolean("dtgov.s-ramp-wagon.snapshots", true);
    }

    public Boolean getSrampWagonReleases() {
        return this.getConfiguration().getBoolean("dtgov.s-ramp-wagon.releases", true);
    }

    public String getGovernanceWorkflowGroup() {
        return this.getConfiguration().getString("dtgov.workflows.group", DEFAULT_GOVERNANCE_WORKFLOW_GROUP);
    }

    public String getGovernanceWorkflowName() {
        return this.getConfiguration().getString("dtgov.workflows.name", DEFAULT_GOVERNANCE_WORKFLOW_NAME);
    }

    public String getGovernanceWorkflowVersion() {
        String defaultDtGovVersion = Release.getGovernanceVersion();
        if (defaultDtGovVersion == null || defaultDtGovVersion.equals("unknown")) {
            defaultDtGovVersion = DEFAULT_GOVERNANCE_WORKFLOW_VERSION;
        }
        return this.getConfiguration().getString("dtgov.workflows.version", defaultDtGovVersion);
    }

    public String getGovernanceWorkflowPackage() {
        return this.getConfiguration().getString("dtgov.workflows.package", DEFAULT_GOVERNANCE_WORKFLOW_PACKAGE);
    }

    static {
        String configFile = System.getProperty("governance.file.name");
        String refreshDelayStr = System.getProperty("governance.file.refresh");
        Long refreshDelay = 5000L;
        if (refreshDelayStr != null) {
            refreshDelay = new Long(refreshDelayStr);
        }
        configuration = ConfigurationFactory.createConfig((String)configFile, (String)"dtgov.properties", (Long)refreshDelay, (String)"/governance.config.txt", Governance.class);
    }
}

