/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance.services;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.downloads.overlord.sramp._2013.auditing.AuditEntry;
import org.jboss.downloads.overlord.sramp._2013.auditing.AuditItemType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.dtgov.common.Target;
import org.overlord.dtgov.server.i18n.Messages;
import org.overlord.dtgov.services.deploy.Deployer;
import org.overlord.dtgov.services.deploy.DeployerFactory;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.audit.AuditUtils;
import org.overlord.sramp.governance.Governance;
import org.overlord.sramp.governance.SlashDecoder;
import org.overlord.sramp.governance.SrampAtomApiClientFactory;
import org.overlord.sramp.governance.ValueEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/deploy")
public class DeploymentResource {
    private static Logger logger = LoggerFactory.getLogger(DeploymentResource.class);

    @POST
    @Path(value="{target}/{uuid}")
    @Produces(value={"application/xml"})
    public Map<String, ValueEntity> deploy(@Context HttpServletRequest request, @PathParam(value="target") String targetRef, @PathParam(value="uuid") String uuid) throws Exception {
        Governance governance = new Governance();
        HashMap<String, ValueEntity> results = new HashMap<String, ValueEntity>();
        targetRef = SlashDecoder.decode(targetRef);
        uuid = SlashDecoder.decode(uuid);
        SrampAtomApiClient client = SrampAtomApiClientFactory.createAtomApiClient();
        BaseArtifactType artifact = client.getArtifactMetaData(uuid);
        Target target = governance.getTargets().get(targetRef);
        if (target == null) {
            logger.error(Messages.i18n.format("DeploymentResource.NoTarget", new Object[]{targetRef}));
            throw new SrampAtomException(Messages.i18n.format("DeploymentResource.NoTarget", new Object[]{targetRef}));
        }
        BaseArtifactType prevVersionArtifact = this.getCurrentlyDeployedVersion(client, artifact, target);
        Deployer deployer = DeployerFactory.createDeployer((String)target.getType().name());
        if (deployer == null) {
            throw new Exception(Messages.i18n.format("DeploymentResource.TargetTypeNotFound", new Object[]{target.getType()}));
        }
        if (prevVersionArtifact != null) {
            this.undeploy(request, client, prevVersionArtifact, target, deployer);
        }
        String deploymentTarget = target.getType().toString() + ":";
        try {
            deploymentTarget = deploymentTarget + deployer.deploy(artifact, target, client);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            results.put("status", new ValueEntity("fail"));
            results.put("message", new ValueEntity(e.getMessage()));
            return results;
        }
        String deploymentClassifier = target.getClassifier();
        try {
            artifact = client.getArtifactMetaData(uuid);
            artifact.getClassifiedBy().add(deploymentClassifier);
            client.updateArtifactMetaData(artifact);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            AuditEntry auditEntry = new AuditEntry();
            auditEntry.setType("deploy:deploy");
            DatatypeFactory dtFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar now = dtFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
            auditEntry.setWhen(now);
            auditEntry.setWho(request.getRemoteUser());
            AuditItemType item = AuditUtils.getOrCreateAuditItem((AuditEntry)auditEntry, (String)"deploy:info");
            AuditUtils.setAuditItemProperty((AuditItemType)item, (String)"target", (String)target.getName());
            AuditUtils.setAuditItemProperty((AuditItemType)item, (String)"classifier", (String)target.getClassifier());
            client.addAuditEntry(uuid, auditEntry);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        results.put("status", new ValueEntity("success"));
        results.put("target", new ValueEntity(deploymentTarget));
        return results;
    }

    protected BaseArtifactType getCurrentlyDeployedVersion(SrampAtomApiClient client, BaseArtifactType artifact, Target target) throws Exception {
        BaseArtifactType currentVersionArtifact = null;
        String classifier = target.getClassifier();
        String mavenArtifactId = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.artifactId");
        String mavenGroupId = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"maven.groupId");
        if (mavenArtifactId != null && mavenGroupId != null) {
            QueryResultSet resultSet = client.buildQuery("/s-ramp[@maven.artifactId = ? and @maven.groupId = ? and s-ramp:exactlyClassifiedByAllOf(., ?)]").parameter(mavenArtifactId).parameter(mavenGroupId).parameter(classifier).count(2).query();
            if (resultSet.size() == 2L) {
                throw new Exception(Messages.i18n.format("DeploymentResource.MultipleMavenDeployments", new Object[]{target.getName(), artifact.getName()}));
            }
            if (resultSet.size() == 1L) {
                currentVersionArtifact = client.getArtifactMetaData(resultSet.get(0));
            }
        }
        if (currentVersionArtifact == null) {
            String name = artifact.getName();
            QueryResultSet resultSet = client.buildQuery("/s-ramp[@name = ? and s-ramp:exactlyClassifiedByAllOf(., ?)]").parameter(name).parameter(classifier).count(2).query();
            if (resultSet.size() == 2L) {
                throw new Exception(Messages.i18n.format("DeploymentResource.MultipleSimpleDeployments", new Object[]{target.getName(), artifact.getName()}));
            }
            if (resultSet.size() == 1L) {
                currentVersionArtifact = client.getArtifactMetaData(resultSet.get(0));
            }
        }
        if (currentVersionArtifact == null) {
            // empty if block
        }
        return currentVersionArtifact;
    }

    protected void undeploy(HttpServletRequest request, SrampAtomApiClient client, BaseArtifactType prevVersionArtifact, Target target, Deployer deployer) throws Exception {
        QueryResultSet resultSet = client.buildQuery("/s-ramp/ext/UndeploymentInformation[describesDeployment[@uuid = ?] and @deploy.target = ?]").parameter(prevVersionArtifact.getUuid()).parameter(target.getName()).count(2).query();
        if (resultSet.size() == 1L) {
            BaseArtifactType undeployInfo = client.getArtifactMetaData(resultSet.get(0));
            deployer.undeploy(prevVersionArtifact, undeployInfo, target, client);
            String deploymentClassifier = SrampModelUtils.getCustomProperty((BaseArtifactType)undeployInfo, (String)"deploy.classifier");
            prevVersionArtifact = client.getArtifactMetaData(ArtifactType.valueOf((BaseArtifactType)prevVersionArtifact), prevVersionArtifact.getUuid());
            prevVersionArtifact.getClassifiedBy().remove(deploymentClassifier);
            client.updateArtifactMetaData(prevVersionArtifact);
            client.deleteArtifact(undeployInfo.getUuid(), ArtifactType.valueOf((BaseArtifactType)undeployInfo));
            try {
                AuditEntry auditEntry = new AuditEntry();
                auditEntry.setType("deploy:undeploy");
                DatatypeFactory dtFactory = DatatypeFactory.newInstance();
                XMLGregorianCalendar now = dtFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
                auditEntry.setWhen(now);
                auditEntry.setWho(request.getRemoteUser());
                AuditItemType item = AuditUtils.getOrCreateAuditItem((AuditEntry)auditEntry, (String)"deploy:info");
                AuditUtils.setAuditItemProperty((AuditItemType)item, (String)"target", (String)target.getName());
                AuditUtils.setAuditItemProperty((AuditItemType)item, (String)"classifier", (String)target.getClassifier());
                client.addAuditEntry(prevVersionArtifact.getUuid(), auditEntry);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            logger.warn(Messages.i18n.format("DeploymentResource.UndeploymentInfoNotFound", new Object[]{prevVersionArtifact.getName()}));
        }
    }
}

