/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance.services;

import com.dumbster.smtp.SimpleSmtpServer;
import com.dumbster.smtp.SmtpMessage;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.overlord.sramp.common.test.resteasy.BaseResourceTest;
import org.overlord.sramp.common.test.resteasy.TestPortProvider;

public class NotificationResourceTest
extends BaseResourceTest {
    private static SimpleSmtpServer mailServer;
    private static Integer smtpPort;

    @BeforeClass
    public static void init() {
        smtpPort = 9700 + new Random().nextInt(99);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMail() {
        try {
            mailServer = SimpleSmtpServer.start((int)smtpPort);
            Properties properties = new Properties();
            properties.setProperty("mail.smtp.host", "localhost");
            properties.setProperty("mail.smtp.port", String.valueOf(smtpPort));
            Session mailSession = Session.getDefaultInstance((Properties)properties);
            MimeMessage m = new MimeMessage(mailSession);
            InternetAddress from = new InternetAddress("me@gmail.com");
            InternetAddress[] to = new InternetAddress[]{new InternetAddress("dev@mailinator.com")};
            m.setFrom((Address)from);
            m.setRecipients(Message.RecipientType.TO, (Address[])to);
            m.setSubject("test");
            m.setContent((Object)"test", "text/plain");
            Transport.send((Message)m);
            Assert.assertTrue((mailServer.getReceivedEmailSize() > 0 ? 1 : 0) != 0);
            Iterator iter = mailServer.getReceivedEmail();
            while (iter.hasNext()) {
                SmtpMessage email = (SmtpMessage)iter.next();
                System.out.println(email.getBody());
                Assert.assertEquals((Object)"test", (Object)email.getBody());
            }
        }
        catch (AddressException e) {
            e.printStackTrace();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        finally {
            mailServer.stop();
        }
    }

    @Test
    @Ignore
    public void testNotify() {
        try {
            String notificationUrl = "/dtgov/notify/email/dev/deployed/dev/${uuid}";
            String uuid = "3c7bb7f7-a811-4080-82db-5ece86993a11";
            URL url = new URL(TestPortProvider.generateURL((String)notificationUrl.replace("${uuid}", uuid)));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                InputStream is = (InputStream)connection.getContent();
                String reply = IOUtils.toString((InputStream)is);
                System.out.println("reply=" + reply);
            } else {
                System.err.println("endpoint could not be reached");
                Assert.fail();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    static {
        smtpPort = 25;
    }
}

