/*
 * Copyright 2012 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.overlord.sramp.governance.workflow;

import org.overlord.commons.services.ServiceRegistryUtil;
import org.overlord.dtgov.server.i18n.Messages;

public class WorkflowFactory {
    /**
     * Return a new instance of the persistence manager.
     */
    public static BpmManager newInstance() {
        BpmManager bpmManager = ServiceRegistryUtil.getSingleService(BpmManager.class);
        if (bpmManager == null)
            throw new RuntimeException(Messages.i18n.format("WorkflowFactory.MissingBPMProvider")); //$NON-NLS-1$
        return bpmManager;
    }
}
