/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.jbpm;

import java.util.Collection;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.kie.services.impl.model.ProcessInstanceDesc;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.overlord.dtgov.jbpm.util.KieSrampUtil;
import org.overlord.dtgov.jbpm.util.ProcessEngineService;
import org.overlord.dtgov.server.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Transactional
public class ProcessBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    @ApplicationScoped
    private ProcessEngineService processEngineService;
    @Inject
    TaskService taskService;

    @PreDestroy
    public void cleanup() {
        this.logger.info(Messages.i18n.format("ProcessBean.CleaningJBPM", new Object[0]));
        this.processEngineService.closeAllRuntimeManagers();
    }

    public long startProcess(String deploymentId, String processId, Map<String, Object> parameters) throws Exception {
        long processInstanceId = -1L;
        try {
            KieSrampUtil kieSrampUtil = new KieSrampUtil();
            RuntimeManager runtimeManager = kieSrampUtil.getRuntimeManager(this.processEngineService, deploymentId);
            RuntimeEngine runtime = runtimeManager.getRuntimeEngine(EmptyContext.get());
            KieSession ksession = runtime.getKieSession();
            ProcessInstance processInstance = ksession.startProcess(processId, parameters);
            processInstanceId = processInstance.getId();
            this.logger.info(Messages.i18n.format("ProcessBean.Started", new Object[]{processInstanceId}));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return processInstanceId;
    }

    public void stopProcess(long processInstanceId) {
        KieSrampUtil kieSrampUtil = new KieSrampUtil();
        this.logger.debug(Messages.i18n.format("ProcessBean.Stopping", new Object[]{processInstanceId}));
        String deploymentId = this.processEngineService.getProcessInstance(processInstanceId).getDeploymentId();
        RuntimeManager runtimeManager = kieSrampUtil.getRuntimeManager(this.processEngineService, deploymentId);
        RuntimeEngine runtime = runtimeManager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession ksession = runtime.getKieSession();
        ksession.abortProcessInstance(processInstanceId);
        this.logger.debug(Messages.i18n.format("ProcessBean.Stopped", new Object[]{processInstanceId}));
    }

    public void signalProcess(long processInstanceId, String signalType, Object event) {
        KieSrampUtil kieSrampUtil = new KieSrampUtil();
        this.logger.info(Messages.i18n.format("ProcessBean.Signalled", new Object[]{processInstanceId, signalType}));
        String deploymentId = this.processEngineService.getProcessInstance(processInstanceId).getDeploymentId();
        RuntimeManager runtimeManager = kieSrampUtil.getRuntimeManager(this.processEngineService, deploymentId);
        RuntimeEngine runtime = runtimeManager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        KieSession ksession = runtime.getKieSession();
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        ksession.signalEvent(signalType, event, processInstance.getId());
    }

    public Collection<ProcessInstanceDesc> listProcessInstances() throws Exception {
        Collection<ProcessInstanceDesc> processInstances = null;
        try {
            processInstances = this.processEngineService.getProcessInstances();
            for (ProcessInstanceDesc processInstanceDesc : processInstances) {
                this.logger.info(processInstanceDesc.getDeploymentId() + " " + processInstanceDesc.getProcessName() + " " + processInstanceDesc.getId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return processInstances;
    }

    public void listProcessInstanceDetail(long processInstanceId) throws Exception {
        try {
            ProcessInstanceDesc processInstanceDesc = this.processEngineService.getProcessInstance(processInstanceId);
            if (processInstanceDesc != null) {
                this.logger.info(processInstanceDesc.getProcessName());
                this.logger.info("state=" + processInstanceDesc.getState());
                this.logger.info("..");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

