/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.jbpm;

import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.SrampClientQuery;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.governance.SrampAtomApiClientFactory;
import org.overlord.sramp.governance.WorkflowAccesor;

public class WorkflowEventListener
implements ProcessEventListener {
    public void beforeProcessStarted(ProcessStartedEvent event) {
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
    }

    public void beforeProcessCompleted(ProcessCompletedEvent event) {
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        long processId = event.getProcessInstance().getId();
        SrampAtomApiClient client = SrampAtomApiClientFactory.createAtomApiClient();
        String queryStr = "/s-ramp/ext/DtgovWorkflowInstance";
        queryStr = queryStr + "[";
        queryStr = queryStr + "@workflow.processId = ? and ";
        queryStr = queryStr + "@workflow.status = ?";
        queryStr = queryStr + "]";
        SrampClientQuery query = client.buildQuery(queryStr);
        query.parameter(processId + "");
        query.parameter(WorkflowAccesor.WorkflowStatusEnum.RUNNING.name());
        QueryResultSet resultSet = null;
        try {
            resultSet = query.query();
        }
        catch (SrampClientException e) {
        }
        catch (SrampAtomException e) {
            // empty catch block
        }
        if (resultSet != null && resultSet.size() == 1L) {
            ArtifactSummary summary = resultSet.get(0);
            BaseArtifactType artifact = null;
            try {
                artifact = client.getArtifactMetaData(summary.getUuid());
            }
            catch (SrampClientException e) {
            }
            catch (SrampAtomException e) {
                // empty catch block
            }
            if (artifact != null) {
                if (event.getProcessInstance().getState() == 3) {
                    SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"workflow.status", (String)WorkflowAccesor.WorkflowStatusEnum.ABORTED.name());
                } else if (event.getProcessInstance().getState() == 2) {
                    SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"workflow.status", (String)WorkflowAccesor.WorkflowStatusEnum.COMPLETED.name());
                }
                try {
                    client.updateArtifactMetaData(artifact);
                }
                catch (SrampClientException e) {
                }
                catch (SrampAtomException e) {
                    // empty catch block
                }
            }
        }
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
    }

    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
    }

    public void afterNodeLeft(ProcessNodeLeftEvent event) {
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
    }
}

