/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance;

import java.util.HashMap;
import java.util.Map;

public class Query {
    private String srampQuery;
    private String workflowId;
    private Map<String, String> parameters;

    public Query(String srampQuery, String workflowId, Map<String, String> parameters) {
        this.workflowId = workflowId;
        this.setSrampQuery(srampQuery);
        this.setParameters(parameters);
    }

    public Query(String srampQuery, String workflowId) {
        this.workflowId = workflowId;
        this.setSrampQuery(srampQuery);
        this.parameters = new HashMap<String, String>();
    }

    public void setSrampQuery(String srampQuery) {
        this.srampQuery = srampQuery;
    }

    public String getSrampQuery() {
        return this.srampQuery;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public Map<String, Object> getParsedParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.parameters != null) {
            params.putAll(this.parameters);
        }
        return params;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Query addParameter(String key, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, value);
        return this;
    }

    public String toString() {
        return "srampQuery=" + this.srampQuery + "\nworkflowId=" + this.workflowId + "\nparameters=" + this.getParsedParameters();
    }

    public Query replaceParametersValues(String toFind, String replace) {
        if (this.parameters != null && !this.parameters.isEmpty()) {
            for (String key : this.parameters.keySet()) {
                this.parameters.put(key, this.parameters.get(key).replace(toFind, replace));
            }
        }
        return this;
    }
}

