/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.dtgov.common.Target;
import org.overlord.dtgov.common.targets.TargetType;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.governance.SrampAtomApiClientFactory;

public class TargetFactory {
    public static Target toTarget(BaseArtifactType artifact) {
        String type = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.type");
        TargetType typeEnum = TargetType.value((String)type);
        String name = artifact.getName();
        String description = artifact.getDescription();
        String classifier = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.classifiers");
        Target target = null;
        if (typeEnum != null) {
            switch (typeEnum) {
                case RHQ: {
                    String rhq_baseUrl = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.baseUrl");
                    String rhq_pluginName = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.pluginName");
                    String rhq_user = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.user");
                    String rhq_password = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.password");
                    String rhq_group = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.group");
                    target = Target.rhq((String)name, (String)classifier, (String)rhq_user, (String)rhq_password, (String)rhq_baseUrl, (String)rhq_pluginName, (String)rhq_group);
                    break;
                }
                case MAVEN: {
                    String maven_isReleaseEnabled = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.releaseEnabled");
                    String maven_isSnapshotEnabled = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.snapshotEnabled");
                    String maven_user = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.user");
                    String maven_password = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.password");
                    String maven_repository = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.repositoryUrl");
                    boolean isReleaseEnabled = false;
                    boolean isSnapshotEnabled = false;
                    if (StringUtils.isNotBlank((String)maven_isReleaseEnabled) && maven_isReleaseEnabled.equals("true")) {
                        isReleaseEnabled = true;
                    }
                    if (StringUtils.isNotBlank((String)maven_isSnapshotEnabled) && maven_isSnapshotEnabled.equals("true")) {
                        isSnapshotEnabled = true;
                    }
                    target = Target.maven((String)name, (String)classifier, (String)maven_repository, (String)maven_user, (String)maven_password, (boolean)isReleaseEnabled, (boolean)isSnapshotEnabled);
                    break;
                }
                case CLI: {
                    String cli_host = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.host");
                    String cli_port = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.port");
                    String cli_user = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.user");
                    String cli_password = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.password");
                    Boolean cli_domainMode = "true".equals(SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.domainMode"));
                    String cli_serverGroup = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.serverGroup");
                    target = Target.cli((String)name, (String)classifier, (String)cli_user, (String)cli_password, (String)cli_host, (Integer)new Integer(cli_port), (Boolean)cli_domainMode, (String)cli_serverGroup);
                    break;
                }
                case COPY: {
                    String deployDir = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.deployDir");
                    target = Target.copy((String)name, (String)classifier, (String)deployDir);
                    break;
                }
                case CUSTOM: {
                    String customType = SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"deployment.custom.type");
                    Map properties = SrampModelUtils.getCustomPropertiesByPrefix((BaseArtifactType)artifact, (String)"deployment.custom.property.");
                    HashMap parsed_properties = new HashMap();
                    for (String key : properties.keySet()) {
                        parsed_properties.put(key.substring("deployment.custom.property.".length()), properties.get(key));
                    }
                    target = Target.custom((String)name, (String)classifier, (String)customType, parsed_properties);
                    break;
                }
            }
        }
        if (target != null) {
            target.setDescription(description);
        }
        return target;
    }

    public static List<Target> asList(QueryResultSet resultSet) throws SrampClientException, SrampAtomException {
        ArrayList<Target> list = new ArrayList<Target>();
        SrampAtomApiClient client = SrampAtomApiClientFactory.createAtomApiClient();
        for (ArtifactSummary artifactSummary : resultSet) {
            BaseArtifactType artifact = client.getArtifactMetaData(artifactSummary.getUuid());
            Target target = TargetFactory.toTarget(artifact);
            if (target == null) continue;
            list.add(target);
        }
        return list;
    }
}

