/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.SrampClientQuery;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.governance.SrampAtomApiClientFactory;

public class WorkflowAccesor {
    private final SrampAtomApiClient _client = SrampAtomApiClientFactory.createAtomApiClient();

    private BaseArtifactType toWorkflowArtifact(String uuid, String targetUUID, String targetName, String workflow, WorkflowStatusEnum status, Map<String, String> parameters) {
        ExtendedArtifactType artifact = new ExtendedArtifactType();
        artifact.setUuid(uuid);
        artifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        artifact.setExtendedType("DtgovWorkflowInstance");
        artifact.setName(this.buildArtifactName(targetName));
        SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"workflow", (String)workflow);
        SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"workflow.status", (String)status.name());
        SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"workflow.artifactId", (String)targetUUID);
        SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"workflow.artifactName", (String)targetName);
        if (parameters != null && parameters.size() > 0) {
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"workflow.numParams", (String)(parameters.size() + ""));
            for (String param_key : parameters.keySet()) {
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)("workflow.param." + param_key), (String)parameters.get(param_key));
            }
        }
        SrampModelUtils.addGenericRelationship((BaseArtifactType)artifact, (String)"governs", (String)targetUUID);
        return artifact;
    }

    public BaseArtifactType save(String workflowUUID, String targetUUID, String targetName, String workflow, Map<String, String> parameters) throws SrampClientException, SrampAtomException {
        BaseArtifactType artifact = this.toWorkflowArtifact(workflowUUID, targetUUID, targetName, workflow, WorkflowStatusEnum.CREATED, parameters);
        return this._client.createArtifact(artifact);
    }

    public void update(BaseArtifactType artifact, long processInstanceId) throws SrampClientException, SrampAtomException {
        SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"workflow.status", (String)WorkflowStatusEnum.RUNNING.name());
        SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"workflow.processId", (String)String.valueOf(processInstanceId));
        this._client.updateArtifactMetaData(artifact);
    }

    public List<Long> getProcessIds(String targetUUID) throws SrampClientException, SrampAtomException {
        ArrayList<Long> processes = new ArrayList<Long>();
        String query = "/s-ramp/ext/DtgovWorkflowInstance";
        query = query + "[@workflow.artifactId= ?]";
        SrampClientQuery queryClient = this._client.buildQuery(query);
        queryClient = queryClient.propertyName("workflow.processId");
        queryClient = queryClient.parameter(targetUUID);
        QueryResultSet resultSet = queryClient.query();
        for (ArtifactSummary summary : resultSet) {
            String processId = summary.getCustomPropertyValue("workflow.processId");
            processes.add(new Long(processId));
        }
        return processes;
    }

    public boolean existRunningWorkflow(String targetUUID, String targetName, String workflow, String processInstanceId, Map<String, String> parameters) throws SrampClientException, SrampAtomException {
        SrampClientQuery query = this.buildQuery(targetUUID, targetName, workflow, processInstanceId, null, parameters);
        QueryResultSet resultSet = (query = query.startIndex(0)).query();
        return resultSet.size() > 0L;
    }

    private String buildArtifactName(String targetName) {
        return targetName + "_workflow";
    }

    private SrampClientQuery buildQuery(String targetUUID, String targetName, String workflow, String processInstanceId, WorkflowStatusEnum status, Map<String, String> parameters) {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("/s-ramp/ext/DtgovWorkflowInstance");
        ArrayList<String> criteria = new ArrayList<String>();
        ArrayList<String> params = new ArrayList<String>();
        criteria.add("fn:matches(@name, ?)");
        params.add(this.buildArtifactName(targetName));
        criteria.add("@workflow.artifactId= ?");
        params.add(targetUUID);
        criteria.add("@workflow.artifactName= ?");
        params.add(targetName);
        if (StringUtils.isNotBlank((String)workflow)) {
            criteria.add("@workflow= ?");
            params.add(workflow);
        }
        if (StringUtils.isNotBlank((String)processInstanceId)) {
            criteria.add("@workflow.processId= ?");
            params.add(processInstanceId);
        }
        if (status != null) {
            criteria.add("@workflow.status= ?");
            params.add(status.name());
        }
        if (parameters != null && parameters.size() > 0) {
            criteria.add("@workflow.numParams= ?");
            params.add(parameters.size() + "");
            for (String param_key : parameters.keySet()) {
                criteria.add("@workflow.param." + param_key + "= ?");
                params.add(parameters.get(param_key));
            }
        }
        if (criteria.size() > 0) {
            queryBuilder.append("[");
            queryBuilder.append(StringUtils.join(criteria, (String)" and "));
            queryBuilder.append("]");
        }
        SrampClientQuery query = this._client.buildQuery(queryBuilder.toString());
        for (Object e : params) {
            if (e instanceof String) {
                query.parameter((String)e);
            }
            if (!(e instanceof Calendar)) continue;
            query.parameter((Calendar)e);
        }
        return query;
    }

    public SrampAtomApiClient getClient() {
        return this._client;
    }

    public static enum WorkflowStatusEnum implements Serializable
    {
        CREATED,
        RUNNING,
        ABORTED,
        COMPLETED;

    }
}

