/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance.workflow.jbpm;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import org.jbpm.kie.services.impl.model.ProcessInstanceDesc;
import org.overlord.dtgov.jbpm.ProcessBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/process")
@RequestScoped
public class ProcessService {
    @Inject
    @ApplicationScoped
    private ProcessBean processBean;
    private static Logger logger = LoggerFactory.getLogger(ProcessService.class);

    @POST
    @Path(value="start/{deploymentId}/{processId}")
    public String startProcess(@Context HttpServletRequest request, @PathParam(value="deploymentId") String deploymentId, @PathParam(value="processId") String processId) throws Exception {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            context.put(name, request.getParameter(name));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Starting process %s %s with %d parameters", new Object[]{deploymentId, processId, context.size()});
        }
        Long processInstanceId = this.processBean.startProcess(deploymentId, processId, context);
        return String.valueOf(processInstanceId);
    }

    @PUT
    @Path(value="signal/{processInstanceId}/{signalType}/{event}")
    public void signalProcess(@PathParam(value="processInstanceId") Long processInstanceId, @PathParam(value="signalType") String signalType, @PathParam(value="event") String event) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Signalling processInstanceId %d with signalType %s and event $s", new Object[]{processInstanceId, signalType, event});
        }
        this.processBean.signalProcess(processInstanceId, signalType, event);
    }

    @PUT
    @Path(value="stop/{artifactUUID}/{processInstanceId}")
    public void stopProcess(@PathParam(value="processInstanceId") Long processInstanceId, @PathParam(value="artifactUUID") String artifactUUID) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.info("Stopping Process with Id %d for the artifact with uuid %s", (Object)processInstanceId, (Object)artifactUUID);
        }
        this.processBean.stopProcess(processInstanceId);
    }

    @GET
    @Path(value="list")
    public String list() throws Exception {
        Collection<ProcessInstanceDesc> processes = this.processBean.listProcessInstances();
        if (processes == null) {
            return "0";
        }
        return processes.size() + "";
    }
}

