/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance.services;

import com.dumbster.smtp.SimpleSmtpServer;
import com.dumbster.smtp.SmtpMessage;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class NotificationResourceTest {
    private static SimpleSmtpServer mailServer;
    private static Integer smtpPort;

    @BeforeClass
    public static void init() {
        smtpPort = 9700 + new Random().nextInt(99);
    }

    @Test
    public void testMail() {
        try {
            mailServer = SimpleSmtpServer.start((int)smtpPort);
            Properties properties = new Properties();
            properties.setProperty("mail.smtp.host", "localhost");
            properties.setProperty("mail.smtp.port", String.valueOf(smtpPort));
            Session mailSession = Session.getDefaultInstance((Properties)properties);
            MimeMessage m = new MimeMessage(mailSession);
            InternetAddress from = new InternetAddress("me@gmail.com");
            InternetAddress[] to = new InternetAddress[]{new InternetAddress("dev@mailinator.com")};
            m.setFrom((Address)from);
            m.setRecipients(Message.RecipientType.TO, (Address[])to);
            m.setSubject("test");
            m.setContent((Object)"test", "text/plain");
            Transport.send((Message)m);
            Assert.assertTrue((mailServer.getReceivedEmailSize() > 0 ? 1 : 0) != 0);
            Iterator iter = mailServer.getReceivedEmail();
            while (iter.hasNext()) {
                SmtpMessage email = (SmtpMessage)iter.next();
                System.out.println(email.getBody());
                Assert.assertEquals((Object)"test", (Object)email.getBody());
            }
        }
        catch (AddressException e) {
            throw new RuntimeException(e);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        finally {
            mailServer.stop();
        }
    }

    static {
        smtpPort = 25;
    }
}

