/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.auth.jboss7;

import java.io.File;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import org.jboss.security.SecurityContextAssociation;
import org.overlord.commons.auth.util.SAMLAssertionFactory;
import org.overlord.commons.auth.util.SAMLBearerTokenUtil;

public class Jboss7SAMLAssertionFactory
implements SAMLAssertionFactory {
    public boolean accept() {
        File f;
        String property = System.getProperty("jboss.server.config.dir");
        return property != null && (f = new File(property, "standalone.xml")).isFile();
    }

    public String createSAMLAssertion(String issuerName, String forService, int timeValidInMillis) {
        try {
            Principal principal = SecurityContextAssociation.getPrincipal();
            Set userRoles = SecurityContextAssociation.getSecurityContext().getAuthorizationManager().getUserRoles(principal);
            HashSet<String> roles = new HashSet<String>();
            if (userRoles != null) {
                for (Principal role : userRoles) {
                    roles.add(role.getName());
                }
            }
            return SAMLBearerTokenUtil.createSAMLAssertion((Principal)principal, roles, (String)issuerName, (String)forService, (int)timeValidInMillis);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

