/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.auth.tomcat7;

import java.io.File;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.realm.GenericPrincipal;
import org.overlord.commons.auth.tomcat7.Messages;
import org.overlord.commons.auth.util.IRoleGenerator;

public class Tomcat7RoleGenerator
implements IRoleGenerator {
    public boolean accept() {
        File f;
        String property = System.getProperty("catalina.home");
        return property != null && (f = new File(property, "bin/catalina.sh")).isFile();
    }

    public Set<String> generateRoles(HttpServletRequest request) {
        try {
            HashSet<String> roles = new HashSet<String>();
            Principal principal = request.getUserPrincipal();
            if (principal instanceof GenericPrincipal) {
                String[] gpRoles;
                GenericPrincipal gp = (GenericPrincipal)principal;
                for (String role : gpRoles = gp.getRoles()) {
                    roles.add(role);
                }
                return roles;
            }
            if (principal instanceof User) {
                User tomcatUser = (User)principal;
                Iterator iter = tomcatUser.getRoles();
                while (iter.hasNext()) {
                    Role tomcatRole = (Role)iter.next();
                    roles.add(tomcatRole.getRolename());
                }
                return roles;
            }
            throw new Exception(Messages.getString("TomcatSAMLAssertionFactory.UnexpectedPrincipalType") + principal.getClass());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

