/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.auth.saml.sp;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.overlord.commons.auth.saml.sp.KeyManagerConfigProvider;
import org.picketlink.common.exceptions.TrustKeyConfigurationException;
import org.picketlink.common.exceptions.TrustKeyProcessingException;
import org.picketlink.config.federation.AuthPropertyType;
import org.picketlink.identity.federation.core.impl.KeyStoreKeyManager;

public class OverlordSPKeyStoreKeyManager
extends KeyStoreKeyManager {
    private KeyManagerConfigProvider configProvider;

    public void setAuthProperties(List<AuthPropertyType> authList) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        this.configProvider = this.createConfigProvider(authList);
        ArrayList<AuthPropertyType> auths = new ArrayList<AuthPropertyType>();
        auths.add(this.create("KeyStoreURL", this.configProvider.getSamlKeystoreUrl()));
        auths.add(this.create("KeyStorePass", this.configProvider.getSamlKeystorePassword()));
        auths.add(this.create("SigningKeyAlias", this.configProvider.getSamlSigningKeyAlias()));
        auths.add(this.create("SigningKeyPass", this.configProvider.getSamlSigningKeyPassword()));
        super.setAuthProperties(auths);
    }

    private KeyManagerConfigProvider createConfigProvider(List<AuthPropertyType> authList) {
        try {
            for (AuthPropertyType auth : authList) {
                if (!auth.getKey().equals("ConfigProviderClass")) continue;
                String classname = auth.getValue();
                Class<?> clazz = this.loadClass(classname);
                return (KeyManagerConfigProvider)clazz.newInstance();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Configuration error: could not create 'ConfigProviderClass' specified in picketlink.xml", e);
        }
        throw new RuntimeException("Configuration error: no 'ConfigProviderClass' specified in picketlink.xml");
    }

    private Class<?> loadClass(String classname) {
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(classname);
            }
            catch (ClassNotFoundException e2) {
                try {
                    return ((Object)((Object)this)).getClass().getClassLoader().loadClass(classname);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException("Failed to load config provider class: " + classname);
                }
            }
        }
    }

    private AuthPropertyType create(String key, String value) {
        AuthPropertyType rval = new AuthPropertyType();
        rval.setKey(key);
        rval.setValue(value);
        return rval;
    }

    public PublicKey getValidatingKey(String domain) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        return this.getSigningKeyPair().getPublic();
    }
}

